/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GatewayCreateProducerGithub gatewayCreateProducerGithub is a command that creates github producer [Deprecated: Use dynamic-secret-create-github command]
type GatewayCreateProducerGithub struct {
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Github app id
	GithubAppId *int64 `json:"github-app-id,omitempty"`
	// App private key
	GithubAppPrivateKey *string `json:"github-app-private-key,omitempty"`
	// Base URL
	GithubBaseUrl *string `json:"github-base-url,omitempty"`
	// GitHub application installation id
	InstallationId *int64 `json:"installation-id,omitempty"`
	// Optional, mutually exclusive with installation id, GitHub organization name
	InstallationOrganization *string `json:"installation-organization,omitempty"`
	// Optional, mutually exclusive with installation id, GitHub repository '<owner>/<repo-name>'
	InstallationRepository *string `json:"installation-repository,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Dynamic secret name
	Name string `json:"name"`
	// Add tags attached to this object
	Tags *[]string `json:"tags,omitempty"`
	// Target name
	TargetName *string `json:"target-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// Optional - installation token's allowed permissions
	TokenPermissions *[]string `json:"token-permissions,omitempty"`
	// Optional - installation token's allowed repositories
	TokenRepositories *[]string `json:"token-repositories,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGatewayCreateProducerGithub instantiates a new GatewayCreateProducerGithub object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGatewayCreateProducerGithub(name string, ) *GatewayCreateProducerGithub {
	this := GatewayCreateProducerGithub{}
	var githubBaseUrl string = "https://api.github.com/"
	this.GithubBaseUrl = &githubBaseUrl
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewGatewayCreateProducerGithubWithDefaults instantiates a new GatewayCreateProducerGithub object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGatewayCreateProducerGithubWithDefaults() *GatewayCreateProducerGithub {
	this := GatewayCreateProducerGithub{}
	var githubBaseUrl string = "https://api.github.com/"
	this.GithubBaseUrl = &githubBaseUrl
	var json bool = false
	this.Json = &json
	return &this
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *GatewayCreateProducerGithub) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetGithubAppId returns the GithubAppId field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetGithubAppId() int64 {
	if o == nil || o.GithubAppId == nil {
		var ret int64
		return ret
	}
	return *o.GithubAppId
}

// GetGithubAppIdOk returns a tuple with the GithubAppId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetGithubAppIdOk() (*int64, bool) {
	if o == nil || o.GithubAppId == nil {
		return nil, false
	}
	return o.GithubAppId, true
}

// HasGithubAppId returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasGithubAppId() bool {
	if o != nil && o.GithubAppId != nil {
		return true
	}

	return false
}

// SetGithubAppId gets a reference to the given int64 and assigns it to the GithubAppId field.
func (o *GatewayCreateProducerGithub) SetGithubAppId(v int64) {
	o.GithubAppId = &v
}

// GetGithubAppPrivateKey returns the GithubAppPrivateKey field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetGithubAppPrivateKey() string {
	if o == nil || o.GithubAppPrivateKey == nil {
		var ret string
		return ret
	}
	return *o.GithubAppPrivateKey
}

// GetGithubAppPrivateKeyOk returns a tuple with the GithubAppPrivateKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetGithubAppPrivateKeyOk() (*string, bool) {
	if o == nil || o.GithubAppPrivateKey == nil {
		return nil, false
	}
	return o.GithubAppPrivateKey, true
}

// HasGithubAppPrivateKey returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasGithubAppPrivateKey() bool {
	if o != nil && o.GithubAppPrivateKey != nil {
		return true
	}

	return false
}

// SetGithubAppPrivateKey gets a reference to the given string and assigns it to the GithubAppPrivateKey field.
func (o *GatewayCreateProducerGithub) SetGithubAppPrivateKey(v string) {
	o.GithubAppPrivateKey = &v
}

// GetGithubBaseUrl returns the GithubBaseUrl field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetGithubBaseUrl() string {
	if o == nil || o.GithubBaseUrl == nil {
		var ret string
		return ret
	}
	return *o.GithubBaseUrl
}

// GetGithubBaseUrlOk returns a tuple with the GithubBaseUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetGithubBaseUrlOk() (*string, bool) {
	if o == nil || o.GithubBaseUrl == nil {
		return nil, false
	}
	return o.GithubBaseUrl, true
}

// HasGithubBaseUrl returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasGithubBaseUrl() bool {
	if o != nil && o.GithubBaseUrl != nil {
		return true
	}

	return false
}

// SetGithubBaseUrl gets a reference to the given string and assigns it to the GithubBaseUrl field.
func (o *GatewayCreateProducerGithub) SetGithubBaseUrl(v string) {
	o.GithubBaseUrl = &v
}

// GetInstallationId returns the InstallationId field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetInstallationId() int64 {
	if o == nil || o.InstallationId == nil {
		var ret int64
		return ret
	}
	return *o.InstallationId
}

// GetInstallationIdOk returns a tuple with the InstallationId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetInstallationIdOk() (*int64, bool) {
	if o == nil || o.InstallationId == nil {
		return nil, false
	}
	return o.InstallationId, true
}

// HasInstallationId returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasInstallationId() bool {
	if o != nil && o.InstallationId != nil {
		return true
	}

	return false
}

// SetInstallationId gets a reference to the given int64 and assigns it to the InstallationId field.
func (o *GatewayCreateProducerGithub) SetInstallationId(v int64) {
	o.InstallationId = &v
}

// GetInstallationOrganization returns the InstallationOrganization field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetInstallationOrganization() string {
	if o == nil || o.InstallationOrganization == nil {
		var ret string
		return ret
	}
	return *o.InstallationOrganization
}

// GetInstallationOrganizationOk returns a tuple with the InstallationOrganization field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetInstallationOrganizationOk() (*string, bool) {
	if o == nil || o.InstallationOrganization == nil {
		return nil, false
	}
	return o.InstallationOrganization, true
}

// HasInstallationOrganization returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasInstallationOrganization() bool {
	if o != nil && o.InstallationOrganization != nil {
		return true
	}

	return false
}

// SetInstallationOrganization gets a reference to the given string and assigns it to the InstallationOrganization field.
func (o *GatewayCreateProducerGithub) SetInstallationOrganization(v string) {
	o.InstallationOrganization = &v
}

// GetInstallationRepository returns the InstallationRepository field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetInstallationRepository() string {
	if o == nil || o.InstallationRepository == nil {
		var ret string
		return ret
	}
	return *o.InstallationRepository
}

// GetInstallationRepositoryOk returns a tuple with the InstallationRepository field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetInstallationRepositoryOk() (*string, bool) {
	if o == nil || o.InstallationRepository == nil {
		return nil, false
	}
	return o.InstallationRepository, true
}

// HasInstallationRepository returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasInstallationRepository() bool {
	if o != nil && o.InstallationRepository != nil {
		return true
	}

	return false
}

// SetInstallationRepository gets a reference to the given string and assigns it to the InstallationRepository field.
func (o *GatewayCreateProducerGithub) SetInstallationRepository(v string) {
	o.InstallationRepository = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GatewayCreateProducerGithub) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *GatewayCreateProducerGithub) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *GatewayCreateProducerGithub) SetName(v string) {
	o.Name = v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *GatewayCreateProducerGithub) SetTags(v []string) {
	o.Tags = &v
}

// GetTargetName returns the TargetName field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetTargetName() string {
	if o == nil || o.TargetName == nil {
		var ret string
		return ret
	}
	return *o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetTargetNameOk() (*string, bool) {
	if o == nil || o.TargetName == nil {
		return nil, false
	}
	return o.TargetName, true
}

// HasTargetName returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasTargetName() bool {
	if o != nil && o.TargetName != nil {
		return true
	}

	return false
}

// SetTargetName gets a reference to the given string and assigns it to the TargetName field.
func (o *GatewayCreateProducerGithub) SetTargetName(v string) {
	o.TargetName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GatewayCreateProducerGithub) SetToken(v string) {
	o.Token = &v
}

// GetTokenPermissions returns the TokenPermissions field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetTokenPermissions() []string {
	if o == nil || o.TokenPermissions == nil {
		var ret []string
		return ret
	}
	return *o.TokenPermissions
}

// GetTokenPermissionsOk returns a tuple with the TokenPermissions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetTokenPermissionsOk() (*[]string, bool) {
	if o == nil || o.TokenPermissions == nil {
		return nil, false
	}
	return o.TokenPermissions, true
}

// HasTokenPermissions returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasTokenPermissions() bool {
	if o != nil && o.TokenPermissions != nil {
		return true
	}

	return false
}

// SetTokenPermissions gets a reference to the given []string and assigns it to the TokenPermissions field.
func (o *GatewayCreateProducerGithub) SetTokenPermissions(v []string) {
	o.TokenPermissions = &v
}

// GetTokenRepositories returns the TokenRepositories field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetTokenRepositories() []string {
	if o == nil || o.TokenRepositories == nil {
		var ret []string
		return ret
	}
	return *o.TokenRepositories
}

// GetTokenRepositoriesOk returns a tuple with the TokenRepositories field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetTokenRepositoriesOk() (*[]string, bool) {
	if o == nil || o.TokenRepositories == nil {
		return nil, false
	}
	return o.TokenRepositories, true
}

// HasTokenRepositories returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasTokenRepositories() bool {
	if o != nil && o.TokenRepositories != nil {
		return true
	}

	return false
}

// SetTokenRepositories gets a reference to the given []string and assigns it to the TokenRepositories field.
func (o *GatewayCreateProducerGithub) SetTokenRepositories(v []string) {
	o.TokenRepositories = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GatewayCreateProducerGithub) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateProducerGithub) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GatewayCreateProducerGithub) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GatewayCreateProducerGithub) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GatewayCreateProducerGithub) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.GithubAppId != nil {
		toSerialize["github-app-id"] = o.GithubAppId
	}
	if o.GithubAppPrivateKey != nil {
		toSerialize["github-app-private-key"] = o.GithubAppPrivateKey
	}
	if o.GithubBaseUrl != nil {
		toSerialize["github-base-url"] = o.GithubBaseUrl
	}
	if o.InstallationId != nil {
		toSerialize["installation-id"] = o.InstallationId
	}
	if o.InstallationOrganization != nil {
		toSerialize["installation-organization"] = o.InstallationOrganization
	}
	if o.InstallationRepository != nil {
		toSerialize["installation-repository"] = o.InstallationRepository
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.TargetName != nil {
		toSerialize["target-name"] = o.TargetName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.TokenPermissions != nil {
		toSerialize["token-permissions"] = o.TokenPermissions
	}
	if o.TokenRepositories != nil {
		toSerialize["token-repositories"] = o.TokenRepositories
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGatewayCreateProducerGithub struct {
	value *GatewayCreateProducerGithub
	isSet bool
}

func (v NullableGatewayCreateProducerGithub) Get() *GatewayCreateProducerGithub {
	return v.value
}

func (v *NullableGatewayCreateProducerGithub) Set(val *GatewayCreateProducerGithub) {
	v.value = val
	v.isSet = true
}

func (v NullableGatewayCreateProducerGithub) IsSet() bool {
	return v.isSet
}

func (v *NullableGatewayCreateProducerGithub) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGatewayCreateProducerGithub(val *GatewayCreateProducerGithub) *NullableGatewayCreateProducerGithub {
	return &NullableGatewayCreateProducerGithub{value: val, isSet: true}
}

func (v NullableGatewayCreateProducerGithub) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGatewayCreateProducerGithub) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


