/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// BastionGlobalConf struct for BastionGlobalConf
type BastionGlobalConf struct {
	AllowedBastionUrls *[]string `json:"allowed_bastion_urls,omitempty"`
	LegacySigningAlg *bool `json:"legacy_signing_alg,omitempty"`
	RdpUsernameSubClaim *string `json:"rdp_username_sub_claim,omitempty"`
	SshUsernameSubClaim *string `json:"ssh_username_sub_claim,omitempty"`
}

// NewBastionGlobalConf instantiates a new BastionGlobalConf object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewBastionGlobalConf() *BastionGlobalConf {
	this := BastionGlobalConf{}
	return &this
}

// NewBastionGlobalConfWithDefaults instantiates a new BastionGlobalConf object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewBastionGlobalConfWithDefaults() *BastionGlobalConf {
	this := BastionGlobalConf{}
	return &this
}

// GetAllowedBastionUrls returns the AllowedBastionUrls field value if set, zero value otherwise.
func (o *BastionGlobalConf) GetAllowedBastionUrls() []string {
	if o == nil || o.AllowedBastionUrls == nil {
		var ret []string
		return ret
	}
	return *o.AllowedBastionUrls
}

// GetAllowedBastionUrlsOk returns a tuple with the AllowedBastionUrls field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BastionGlobalConf) GetAllowedBastionUrlsOk() (*[]string, bool) {
	if o == nil || o.AllowedBastionUrls == nil {
		return nil, false
	}
	return o.AllowedBastionUrls, true
}

// HasAllowedBastionUrls returns a boolean if a field has been set.
func (o *BastionGlobalConf) HasAllowedBastionUrls() bool {
	if o != nil && o.AllowedBastionUrls != nil {
		return true
	}

	return false
}

// SetAllowedBastionUrls gets a reference to the given []string and assigns it to the AllowedBastionUrls field.
func (o *BastionGlobalConf) SetAllowedBastionUrls(v []string) {
	o.AllowedBastionUrls = &v
}

// GetLegacySigningAlg returns the LegacySigningAlg field value if set, zero value otherwise.
func (o *BastionGlobalConf) GetLegacySigningAlg() bool {
	if o == nil || o.LegacySigningAlg == nil {
		var ret bool
		return ret
	}
	return *o.LegacySigningAlg
}

// GetLegacySigningAlgOk returns a tuple with the LegacySigningAlg field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BastionGlobalConf) GetLegacySigningAlgOk() (*bool, bool) {
	if o == nil || o.LegacySigningAlg == nil {
		return nil, false
	}
	return o.LegacySigningAlg, true
}

// HasLegacySigningAlg returns a boolean if a field has been set.
func (o *BastionGlobalConf) HasLegacySigningAlg() bool {
	if o != nil && o.LegacySigningAlg != nil {
		return true
	}

	return false
}

// SetLegacySigningAlg gets a reference to the given bool and assigns it to the LegacySigningAlg field.
func (o *BastionGlobalConf) SetLegacySigningAlg(v bool) {
	o.LegacySigningAlg = &v
}

// GetRdpUsernameSubClaim returns the RdpUsernameSubClaim field value if set, zero value otherwise.
func (o *BastionGlobalConf) GetRdpUsernameSubClaim() string {
	if o == nil || o.RdpUsernameSubClaim == nil {
		var ret string
		return ret
	}
	return *o.RdpUsernameSubClaim
}

// GetRdpUsernameSubClaimOk returns a tuple with the RdpUsernameSubClaim field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BastionGlobalConf) GetRdpUsernameSubClaimOk() (*string, bool) {
	if o == nil || o.RdpUsernameSubClaim == nil {
		return nil, false
	}
	return o.RdpUsernameSubClaim, true
}

// HasRdpUsernameSubClaim returns a boolean if a field has been set.
func (o *BastionGlobalConf) HasRdpUsernameSubClaim() bool {
	if o != nil && o.RdpUsernameSubClaim != nil {
		return true
	}

	return false
}

// SetRdpUsernameSubClaim gets a reference to the given string and assigns it to the RdpUsernameSubClaim field.
func (o *BastionGlobalConf) SetRdpUsernameSubClaim(v string) {
	o.RdpUsernameSubClaim = &v
}

// GetSshUsernameSubClaim returns the SshUsernameSubClaim field value if set, zero value otherwise.
func (o *BastionGlobalConf) GetSshUsernameSubClaim() string {
	if o == nil || o.SshUsernameSubClaim == nil {
		var ret string
		return ret
	}
	return *o.SshUsernameSubClaim
}

// GetSshUsernameSubClaimOk returns a tuple with the SshUsernameSubClaim field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BastionGlobalConf) GetSshUsernameSubClaimOk() (*string, bool) {
	if o == nil || o.SshUsernameSubClaim == nil {
		return nil, false
	}
	return o.SshUsernameSubClaim, true
}

// HasSshUsernameSubClaim returns a boolean if a field has been set.
func (o *BastionGlobalConf) HasSshUsernameSubClaim() bool {
	if o != nil && o.SshUsernameSubClaim != nil {
		return true
	}

	return false
}

// SetSshUsernameSubClaim gets a reference to the given string and assigns it to the SshUsernameSubClaim field.
func (o *BastionGlobalConf) SetSshUsernameSubClaim(v string) {
	o.SshUsernameSubClaim = &v
}

func (o BastionGlobalConf) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AllowedBastionUrls != nil {
		toSerialize["allowed_bastion_urls"] = o.AllowedBastionUrls
	}
	if o.LegacySigningAlg != nil {
		toSerialize["legacy_signing_alg"] = o.LegacySigningAlg
	}
	if o.RdpUsernameSubClaim != nil {
		toSerialize["rdp_username_sub_claim"] = o.RdpUsernameSubClaim
	}
	if o.SshUsernameSubClaim != nil {
		toSerialize["ssh_username_sub_claim"] = o.SshUsernameSubClaim
	}
	return json.Marshal(toSerialize)
}

type NullableBastionGlobalConf struct {
	value *BastionGlobalConf
	isSet bool
}

func (v NullableBastionGlobalConf) Get() *BastionGlobalConf {
	return v.value
}

func (v *NullableBastionGlobalConf) Set(val *BastionGlobalConf) {
	v.value = val
	v.isSet = true
}

func (v NullableBastionGlobalConf) IsSet() bool {
	return v.isSet
}

func (v *NullableBastionGlobalConf) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableBastionGlobalConf(val *BastionGlobalConf) *NullableBastionGlobalConf {
	return &NullableBastionGlobalConf{value: val, isSet: true}
}

func (v NullableBastionGlobalConf) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableBastionGlobalConf) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


