/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { EmptyError } from 'rxjs';
import { NAVIGATION_CANCELING_ERROR } from '../navigation_canceling_error';
import { isUrlTree } from '../url_tree';
/**
 * Simple function check, but generic so type inference will flow. Example:
 *
 * function product(a: number, b: number) {
 *   return a * b;
 * }
 *
 * if (isFunction<product>(fn)) {
 *   return fn(1, 2);
 * } else {
 *   throw "Must provide the `product` function";
 * }
 */
export function isFunction(v) {
    return typeof v === 'function';
}
export function isBoolean(v) {
    return typeof v === 'boolean';
}
export function isCanLoad(guard) {
    return guard && isFunction(guard.canLoad);
}
export function isCanActivate(guard) {
    return guard && isFunction(guard.canActivate);
}
export function isCanActivateChild(guard) {
    return guard && isFunction(guard.canActivateChild);
}
export function isCanDeactivate(guard) {
    return guard && isFunction(guard.canDeactivate);
}
export function isCanMatch(guard) {
    return guard && isFunction(guard.canMatch);
}
export function isRedirectingNavigationCancelingError(error) {
    return isNavigationCancelingError(error) && isUrlTree(error.url);
}
export function isNavigationCancelingError(error) {
    return error && error[NAVIGATION_CANCELING_ERROR];
}
export function isEmptyError(e) {
    return e instanceof EmptyError || e?.name === 'EmptyError';
}
//# sourceMappingURL=data:application/json;base64,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