package yundun_bastionhost

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigInstanceSecurityGroups invokes the yundun_bastionhost.ConfigInstanceSecurityGroups API synchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/configinstancesecuritygroups.html
func (client *Client) ConfigInstanceSecurityGroups(request *ConfigInstanceSecurityGroupsRequest) (response *ConfigInstanceSecurityGroupsResponse, err error) {
	response = CreateConfigInstanceSecurityGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigInstanceSecurityGroupsWithChan invokes the yundun_bastionhost.ConfigInstanceSecurityGroups API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/configinstancesecuritygroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigInstanceSecurityGroupsWithChan(request *ConfigInstanceSecurityGroupsRequest) (<-chan *ConfigInstanceSecurityGroupsResponse, <-chan error) {
	responseChan := make(chan *ConfigInstanceSecurityGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigInstanceSecurityGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigInstanceSecurityGroupsWithCallback invokes the yundun_bastionhost.ConfigInstanceSecurityGroups API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/configinstancesecuritygroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigInstanceSecurityGroupsWithCallback(request *ConfigInstanceSecurityGroupsRequest, callback func(response *ConfigInstanceSecurityGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigInstanceSecurityGroupsResponse
		var err error
		defer close(result)
		response, err = client.ConfigInstanceSecurityGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigInstanceSecurityGroupsRequest is the request struct for api ConfigInstanceSecurityGroups
type ConfigInstanceSecurityGroupsRequest struct {
	*requests.RpcRequest
	SecurityGroupIds *[]string `position:"Query" name:"SecurityGroupIds"  type:"Repeated"`
	InstanceId       string    `position:"Query" name:"InstanceId"`
	SourceIp         string    `position:"Query" name:"SourceIp"`
	Lang             string    `position:"Query" name:"Lang"`
}

// ConfigInstanceSecurityGroupsResponse is the response struct for api ConfigInstanceSecurityGroups
type ConfigInstanceSecurityGroupsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigInstanceSecurityGroupsRequest creates a request to invoke ConfigInstanceSecurityGroups API
func CreateConfigInstanceSecurityGroupsRequest() (request *ConfigInstanceSecurityGroupsRequest) {
	request = &ConfigInstanceSecurityGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-bastionhost", "2018-10-10", "ConfigInstanceSecurityGroups", "bastionhost", "openAPI")
	return
}

// CreateConfigInstanceSecurityGroupsResponse creates a response to parse from ConfigInstanceSecurityGroups response
func CreateConfigInstanceSecurityGroupsResponse() (response *ConfigInstanceSecurityGroupsResponse) {
	response = &ConfigInstanceSecurityGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
