package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceMinorVersion invokes the r_kvstore.ModifyInstanceMinorVersion API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifyinstanceminorversion.html
func (client *Client) ModifyInstanceMinorVersion(request *ModifyInstanceMinorVersionRequest) (response *ModifyInstanceMinorVersionResponse, err error) {
	response = CreateModifyInstanceMinorVersionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceMinorVersionWithChan invokes the r_kvstore.ModifyInstanceMinorVersion API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifyinstanceminorversion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyInstanceMinorVersionWithChan(request *ModifyInstanceMinorVersionRequest) (<-chan *ModifyInstanceMinorVersionResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceMinorVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceMinorVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceMinorVersionWithCallback invokes the r_kvstore.ModifyInstanceMinorVersion API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifyinstanceminorversion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyInstanceMinorVersionWithCallback(request *ModifyInstanceMinorVersionRequest, callback func(response *ModifyInstanceMinorVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceMinorVersionResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceMinorVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceMinorVersionRequest is the request struct for api ModifyInstanceMinorVersion
type ModifyInstanceMinorVersionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EffectTime           string           `position:"Query" name:"EffectTime"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Minorversion         string           `position:"Query" name:"Minorversion"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// ModifyInstanceMinorVersionResponse is the response struct for api ModifyInstanceMinorVersion
type ModifyInstanceMinorVersionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyInstanceMinorVersionRequest creates a request to invoke ModifyInstanceMinorVersion API
func CreateModifyInstanceMinorVersionRequest() (request *ModifyInstanceMinorVersionRequest) {
	request = &ModifyInstanceMinorVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ModifyInstanceMinorVersion", "redisa", "openAPI")
	return
}

// CreateModifyInstanceMinorVersionResponse creates a response to parse from ModifyInstanceMinorVersion response
func CreateModifyInstanceMinorVersionResponse() (response *ModifyInstanceMinorVersionResponse) {
	response = &ModifyInstanceMinorVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
