package emas_appmonitor

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPagePerfDistribution invokes the emas_appmonitor.QueryPagePerfDistribution API synchronously
func (client *Client) QueryPagePerfDistribution(request *QueryPagePerfDistributionRequest) (response *QueryPagePerfDistributionResponse, err error) {
	response = CreateQueryPagePerfDistributionResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPagePerfDistributionWithChan invokes the emas_appmonitor.QueryPagePerfDistribution API asynchronously
func (client *Client) QueryPagePerfDistributionWithChan(request *QueryPagePerfDistributionRequest) (<-chan *QueryPagePerfDistributionResponse, <-chan error) {
	responseChan := make(chan *QueryPagePerfDistributionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPagePerfDistribution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPagePerfDistributionWithCallback invokes the emas_appmonitor.QueryPagePerfDistribution API asynchronously
func (client *Client) QueryPagePerfDistributionWithCallback(request *QueryPagePerfDistributionRequest, callback func(response *QueryPagePerfDistributionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPagePerfDistributionResponse
		var err error
		defer close(result)
		response, err = client.QueryPagePerfDistribution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPagePerfDistributionRequest is the request struct for api QueryPagePerfDistribution
type QueryPagePerfDistributionRequest struct {
	*requests.RpcRequest
	MetricType         string           `position:"Body" name:"MetricType"`
	AppVersionStrategy string           `position:"Body" name:"AppVersionStrategy"`
	StartTime          requests.Integer `position:"Body" name:"StartTime"`
	DeviceLevel        string           `position:"Body" name:"DeviceLevel"`
	Province           *[]string        `position:"Body" name:"Province"  type:"Repeated"`
	StatType           string           `position:"Body" name:"StatType"`
	IntervalMinutes    requests.Integer `position:"Body" name:"IntervalMinutes"`
	UniqueAppId        string           `position:"Body" name:"UniqueAppId"`
	EndTime            requests.Integer `position:"Body" name:"EndTime"`
	AppVersion         *[]string        `position:"Body" name:"AppVersion"  type:"Repeated"`
	Page               *[]string        `position:"Body" name:"Page"  type:"Repeated"`
}

// QueryPagePerfDistributionResponse is the response struct for api QueryPagePerfDistribution
type QueryPagePerfDistributionResponse struct {
	*responses.BaseResponse
	RequestId        string             `json:"RequestId" xml:"RequestId"`
	MetricResultList []MetricResultItem `json:"MetricResultList" xml:"MetricResultList"`
}

// CreateQueryPagePerfDistributionRequest creates a request to invoke QueryPagePerfDistribution API
func CreateQueryPagePerfDistributionRequest() (request *QueryPagePerfDistributionRequest) {
	request = &QueryPagePerfDistributionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("emas-appmonitor", "2019-06-11", "QueryPagePerfDistribution", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryPagePerfDistributionResponse creates a response to parse from QueryPagePerfDistribution response
func CreateQueryPagePerfDistributionResponse() (response *QueryPagePerfDistributionResponse) {
	response = &QueryPagePerfDistributionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
