package democenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDemoAccessToken invokes the democenter.DescribeDemoAccessToken API synchronously
// api document: https://help.aliyun.com/api/democenter/describedemoaccesstoken.html
func (client *Client) DescribeDemoAccessToken(request *DescribeDemoAccessTokenRequest) (response *DescribeDemoAccessTokenResponse, err error) {
	response = CreateDescribeDemoAccessTokenResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDemoAccessTokenWithChan invokes the democenter.DescribeDemoAccessToken API asynchronously
// api document: https://help.aliyun.com/api/democenter/describedemoaccesstoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDemoAccessTokenWithChan(request *DescribeDemoAccessTokenRequest) (<-chan *DescribeDemoAccessTokenResponse, <-chan error) {
	responseChan := make(chan *DescribeDemoAccessTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDemoAccessToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDemoAccessTokenWithCallback invokes the democenter.DescribeDemoAccessToken API asynchronously
// api document: https://help.aliyun.com/api/democenter/describedemoaccesstoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDemoAccessTokenWithCallback(request *DescribeDemoAccessTokenRequest, callback func(response *DescribeDemoAccessTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDemoAccessTokenResponse
		var err error
		defer close(result)
		response, err = client.DescribeDemoAccessToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDemoAccessTokenRequest is the request struct for api DescribeDemoAccessToken
type DescribeDemoAccessTokenRequest struct {
	*requests.RpcRequest
	DemoAccessToken string `position:"Body" name:"DemoAccessToken"`
}

// DescribeDemoAccessTokenResponse is the response struct for api DescribeDemoAccessToken
type DescribeDemoAccessTokenResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	DemoAccessToken string `json:"DemoAccessToken" xml:"DemoAccessToken"`
	ExpiredDate     string `json:"ExpiredDate" xml:"ExpiredDate"`
	OpenUserId      string `json:"OpenUserId" xml:"OpenUserId"`
	DemoTrialPage   string `json:"DemoTrialPage" xml:"DemoTrialPage"`
	DemoDetailPage  string `json:"DemoDetailPage" xml:"DemoDetailPage"`
	Edition         string `json:"Edition" xml:"Edition"`
}

// CreateDescribeDemoAccessTokenRequest creates a request to invoke DescribeDemoAccessToken API
func CreateDescribeDemoAccessTokenRequest() (request *DescribeDemoAccessTokenRequest) {
	request = &DescribeDemoAccessTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DemoCenter", "2020-01-21", "DescribeDemoAccessToken", "", "")
	return
}

// CreateDescribeDemoAccessTokenResponse creates a response to parse from DescribeDemoAccessToken response
func CreateDescribeDemoAccessTokenResponse() (response *DescribeDemoAccessTokenResponse) {
	response = &DescribeDemoAccessTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
