package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceCount invokes the cr.GetInstanceCount API synchronously
// api document: https://help.aliyun.com/api/cr/getinstancecount.html
func (client *Client) GetInstanceCount(request *GetInstanceCountRequest) (response *GetInstanceCountResponse, err error) {
	response = CreateGetInstanceCountResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceCountWithChan invokes the cr.GetInstanceCount API asynchronously
// api document: https://help.aliyun.com/api/cr/getinstancecount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceCountWithChan(request *GetInstanceCountRequest) (<-chan *GetInstanceCountResponse, <-chan error) {
	responseChan := make(chan *GetInstanceCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceCountWithCallback invokes the cr.GetInstanceCount API asynchronously
// api document: https://help.aliyun.com/api/cr/getinstancecount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceCountWithCallback(request *GetInstanceCountRequest, callback func(response *GetInstanceCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceCountResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceCountRequest is the request struct for api GetInstanceCount
type GetInstanceCountRequest struct {
	*requests.RpcRequest
}

// GetInstanceCountResponse is the response struct for api GetInstanceCount
type GetInstanceCountResponse struct {
	*responses.BaseResponse
	GetInstanceCountIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                      string `json:"Code" xml:"Code"`
	RequestId                 string `json:"RequestId" xml:"RequestId"`
	Count                     int    `json:"Count" xml:"Count"`
}

// CreateGetInstanceCountRequest creates a request to invoke GetInstanceCount API
func CreateGetInstanceCountRequest() (request *GetInstanceCountRequest) {
	request = &GetInstanceCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "GetInstanceCount", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetInstanceCountResponse creates a response to parse from GetInstanceCount response
func CreateGetInstanceCountResponse() (response *GetInstanceCountResponse) {
	response = &GetInstanceCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
