package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDefenceThread invokes the aegis.DescribeDefenceThread API synchronously
// api document: https://help.aliyun.com/api/aegis/describedefencethread.html
func (client *Client) DescribeDefenceThread(request *DescribeDefenceThreadRequest) (response *DescribeDefenceThreadResponse, err error) {
	response = CreateDescribeDefenceThreadResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDefenceThreadWithChan invokes the aegis.DescribeDefenceThread API asynchronously
// api document: https://help.aliyun.com/api/aegis/describedefencethread.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDefenceThreadWithChan(request *DescribeDefenceThreadRequest) (<-chan *DescribeDefenceThreadResponse, <-chan error) {
	responseChan := make(chan *DescribeDefenceThreadResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDefenceThread(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDefenceThreadWithCallback invokes the aegis.DescribeDefenceThread API asynchronously
// api document: https://help.aliyun.com/api/aegis/describedefencethread.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDefenceThreadWithCallback(request *DescribeDefenceThreadRequest, callback func(response *DescribeDefenceThreadResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDefenceThreadResponse
		var err error
		defer close(result)
		response, err = client.DescribeDefenceThread(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDefenceThreadRequest is the request struct for api DescribeDefenceThread
type DescribeDefenceThreadRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeDefenceThreadResponse is the response struct for api DescribeDefenceThread
type DescribeDefenceThreadResponse struct {
	*responses.BaseResponse
	RequestId                  string   `json:"RequestId" xml:"RequestId"`
	DefenceCountTotal          int      `json:"DefenceCountTotal" xml:"DefenceCountTotal"`
	TamperProofTotal           int      `json:"TamperProofTotal" xml:"TamperProofTotal"`
	DefenceAaggregatCountArray []string `json:"DefenceAaggregatCountArray" xml:"DefenceAaggregatCountArray"`
	TamperProofArray           []string `json:"TamperProofArray" xml:"TamperProofArray"`
	DateArray                  []string `json:"DateArray" xml:"DateArray"`
	TamperProofAaggregateArray []string `json:"TamperProofAaggregateArray" xml:"TamperProofAaggregateArray"`
	DefenceCountArray          []string `json:"DefenceCountArray" xml:"DefenceCountArray"`
}

// CreateDescribeDefenceThreadRequest creates a request to invoke DescribeDefenceThread API
func CreateDescribeDefenceThreadRequest() (request *DescribeDefenceThreadRequest) {
	request = &DescribeDefenceThreadRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeDefenceThread", "vipaegis", "openAPI")
	return
}

// CreateDescribeDefenceThreadResponse creates a response to parse from DescribeDefenceThread response
func CreateDescribeDefenceThreadResponse() (response *DescribeDefenceThreadResponse) {
	response = &DescribeDefenceThreadResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
