/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import java.io.Serializable;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class ResolveResult
implements Serializable {
    static final long serialVersionUID = -4552108072002407559L;
    protected Object resolvedObj;
    protected Name remainingName;

    protected ResolveResult() {
        this.resolvedObj = null;
        this.remainingName = null;
    }

    public ResolveResult(Object o, String s) {
        this.resolvedObj = o;
        try {
            this.remainingName = new CompositeName(s);
        }
        catch (InvalidNameException invalidNameException) {
            this.remainingName = null;
        }
    }

    public ResolveResult(Object o, Name n) {
        this.resolvedObj = o;
        this.remainingName = n == null ? null : (Name)n.clone();
    }

    public void appendRemainingComponent(String s) {
        if (s != null) {
            if (this.remainingName == null) {
                this.remainingName = new CompositeName();
            }
            try {
                this.remainingName.add(s);
            }
            catch (InvalidNameException e) {
                throw new Error(e.getMessage());
            }
        }
    }

    public void appendRemainingName(Name n) {
        if (n != null) {
            if (this.remainingName == null) {
                this.remainingName = (Name)n.clone();
            } else {
                try {
                    this.remainingName.addAll(n);
                }
                catch (InvalidNameException e) {
                    throw new Error(e.getMessage());
                }
            }
        }
    }

    public Name getRemainingName() {
        return this.remainingName;
    }

    public Object getResolvedObj() {
        return this.resolvedObj;
    }

    public void setRemainingName(Name n) {
        this.remainingName = n == null ? null : (Name)n.clone();
    }

    public void setResolvedObj(Object o) {
        this.resolvedObj = o;
    }
}

