//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/network/thrift_proxy/filters/header_to_metadata/v3/header_to_metadata.proto

package header_to_metadatav3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on HeaderToMetadata with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *HeaderToMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HeaderToMetadata with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// HeaderToMetadataMultiError, or nil if none found.
func (m *HeaderToMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *HeaderToMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetRequestRules()) < 1 {
		err := HeaderToMetadataValidationError{
			field:  "RequestRules",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetRequestRules() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HeaderToMetadataValidationError{
						field:  fmt.Sprintf("RequestRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HeaderToMetadataValidationError{
						field:  fmt.Sprintf("RequestRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HeaderToMetadataValidationError{
					field:  fmt.Sprintf("RequestRules[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return HeaderToMetadataMultiError(errors)
	}

	return nil
}

// HeaderToMetadataMultiError is an error wrapping multiple validation errors
// returned by HeaderToMetadata.ValidateAll() if the designated constraints
// aren't met.
type HeaderToMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HeaderToMetadataMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HeaderToMetadataMultiError) AllErrors() []error { return m }

// HeaderToMetadataValidationError is the validation error returned by
// HeaderToMetadata.Validate if the designated constraints aren't met.
type HeaderToMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeaderToMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeaderToMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeaderToMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeaderToMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeaderToMetadataValidationError) ErrorName() string { return "HeaderToMetadataValidationError" }

// Error satisfies the builtin error interface
func (e HeaderToMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderToMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeaderToMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeaderToMetadataValidationError{}

// Validate checks the field values on HeaderToMetadata_KeyValuePair with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *HeaderToMetadata_KeyValuePair) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HeaderToMetadata_KeyValuePair with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// HeaderToMetadata_KeyValuePairMultiError, or nil if none found.
func (m *HeaderToMetadata_KeyValuePair) ValidateAll() error {
	return m.validate(true)
}

func (m *HeaderToMetadata_KeyValuePair) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for MetadataNamespace

	if utf8.RuneCountInString(m.GetKey()) < 1 {
		err := HeaderToMetadata_KeyValuePairValidationError{
			field:  "Key",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := HeaderToMetadata_ValueType_name[int32(m.GetType())]; !ok {
		err := HeaderToMetadata_KeyValuePairValidationError{
			field:  "Type",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Encode

	switch v := m.ValueType.(type) {
	case *HeaderToMetadata_KeyValuePair_Value:
		if v == nil {
			err := HeaderToMetadata_KeyValuePairValidationError{
				field:  "ValueType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Value
	case *HeaderToMetadata_KeyValuePair_RegexValueRewrite:
		if v == nil {
			err := HeaderToMetadata_KeyValuePairValidationError{
				field:  "ValueType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetRegexValueRewrite()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HeaderToMetadata_KeyValuePairValidationError{
						field:  "RegexValueRewrite",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HeaderToMetadata_KeyValuePairValidationError{
						field:  "RegexValueRewrite",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRegexValueRewrite()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HeaderToMetadata_KeyValuePairValidationError{
					field:  "RegexValueRewrite",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return HeaderToMetadata_KeyValuePairMultiError(errors)
	}

	return nil
}

// HeaderToMetadata_KeyValuePairMultiError is an error wrapping multiple
// validation errors returned by HeaderToMetadata_KeyValuePair.ValidateAll()
// if the designated constraints aren't met.
type HeaderToMetadata_KeyValuePairMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HeaderToMetadata_KeyValuePairMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HeaderToMetadata_KeyValuePairMultiError) AllErrors() []error { return m }

// HeaderToMetadata_KeyValuePairValidationError is the validation error
// returned by HeaderToMetadata_KeyValuePair.Validate if the designated
// constraints aren't met.
type HeaderToMetadata_KeyValuePairValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeaderToMetadata_KeyValuePairValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeaderToMetadata_KeyValuePairValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeaderToMetadata_KeyValuePairValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeaderToMetadata_KeyValuePairValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeaderToMetadata_KeyValuePairValidationError) ErrorName() string {
	return "HeaderToMetadata_KeyValuePairValidationError"
}

// Error satisfies the builtin error interface
func (e HeaderToMetadata_KeyValuePairValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderToMetadata_KeyValuePair.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeaderToMetadata_KeyValuePairValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeaderToMetadata_KeyValuePairValidationError{}

// Validate checks the field values on HeaderToMetadata_Rule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *HeaderToMetadata_Rule) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HeaderToMetadata_Rule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// HeaderToMetadata_RuleMultiError, or nil if none found.
func (m *HeaderToMetadata_Rule) ValidateAll() error {
	return m.validate(true)
}

func (m *HeaderToMetadata_Rule) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetHeader()) < 1 {
		err := HeaderToMetadata_RuleValidationError{
			field:  "Header",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_HeaderToMetadata_Rule_Header_Pattern.MatchString(m.GetHeader()) {
		err := HeaderToMetadata_RuleValidationError{
			field:  "Header",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetOnPresent()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HeaderToMetadata_RuleValidationError{
					field:  "OnPresent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HeaderToMetadata_RuleValidationError{
					field:  "OnPresent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOnPresent()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderToMetadata_RuleValidationError{
				field:  "OnPresent",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetOnMissing()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HeaderToMetadata_RuleValidationError{
					field:  "OnMissing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HeaderToMetadata_RuleValidationError{
					field:  "OnMissing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOnMissing()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderToMetadata_RuleValidationError{
				field:  "OnMissing",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Remove

	if len(errors) > 0 {
		return HeaderToMetadata_RuleMultiError(errors)
	}

	return nil
}

// HeaderToMetadata_RuleMultiError is an error wrapping multiple validation
// errors returned by HeaderToMetadata_Rule.ValidateAll() if the designated
// constraints aren't met.
type HeaderToMetadata_RuleMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HeaderToMetadata_RuleMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HeaderToMetadata_RuleMultiError) AllErrors() []error { return m }

// HeaderToMetadata_RuleValidationError is the validation error returned by
// HeaderToMetadata_Rule.Validate if the designated constraints aren't met.
type HeaderToMetadata_RuleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeaderToMetadata_RuleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeaderToMetadata_RuleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeaderToMetadata_RuleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeaderToMetadata_RuleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeaderToMetadata_RuleValidationError) ErrorName() string {
	return "HeaderToMetadata_RuleValidationError"
}

// Error satisfies the builtin error interface
func (e HeaderToMetadata_RuleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderToMetadata_Rule.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeaderToMetadata_RuleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeaderToMetadata_RuleValidationError{}

var _HeaderToMetadata_Rule_Header_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")
