/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_kgp extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Óra Mirinjỹnũ Grinũvisi tá",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Óra Pã Akre tá",
               "ACT",
               "Rỹ Kã óra Akre tá",
               "ACST",
               "Akre tá óra",
               "ACT",
            };
        final String[] Apia = new String[] {
               "Óra Pã Apija tá",
               "",
               "Rỹ Kã óra Apija tá",
               "",
               "Óra Apija tá",
               "",
            };
        final String[] Cook = new String[] {
               "Óra Pã Kuki Goj-vẽso tá",
               "",
               "Rỹ Kã óra Kuki Goj-vẽso tá",
               "",
               "Óra Kuki Goj-vẽso tá",
               "",
            };
        final String[] Cuba = new String[] {
               "Óra Pã Kuma tá",
               "CST",
               "Rỹ Kã óra Kuma tá",
               "CDT",
               "Óra Kuma tá",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Óra Pã Fiji tá",
               "",
               "Rỹ Kã óra Fiji tá",
               "",
               "Óra Fiji tá",
               "",
            };
        final String[] Gulf = new String[] {
               "Óra Gorfu tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Óra Pã Hóvin tá",
               "",
               "Rỹ kã óra Hóvin tá",
               "",
               "Óra Hóvin tá",
               "",
            };
        final String[] Iran = new String[] {
               "Óra Pã Irỹ tá",
               "",
               "Rỹ Kã óra Irỹ tá",
               "",
               "Óra Irỹ tá",
               "",
            };
        final String[] Niue = new String[] {
               "Óra Nĩve tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Óra Pã Omĩnhki tá",
               "",
               "Rỹ Kã óra Omĩnhki tá",
               "",
               "Óra Omĩnhki tá",
               "",
            };
        final String[] Peru = new String[] {
               "Óra Pã Piru tá",
               "",
               "Rỹ Kã óra Piru tá",
               "",
               "Óra Piru tá",
               "",
            };
        final String[] Truk = new String[] {
               "Óra Suuki tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Óra Vejki Goj-vẽso tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Óra Pã Sire tá",
               "",
               "Rỹ Kã óra Sire tá",
               "",
               "Óra Sire tá",
               "",
            };
        final String[] China = new String[] {
               "Óra Pã Sĩnỹ tá",
               "CST",
               "Rỹ Kã óra Sĩnỹ tá",
               "CDT",
               "Óra Sĩnỹ tá",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Óra Kokonh Goj-vẽso tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Óra Navinh tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Óra Pã Ĩnija tá",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Óra Pã Japã tá",
               "JST",
               "Rỹ Kã óra Japã tá",
               "JDT",
               "Óra Japã tá",
               "JT",
            };
        final String[] Korea = new String[] {
               "Óra Pã Koréja tá",
               "KST",
               "Rỹ Kã óra Koréja tá",
               "KST",
               "Óra Koréja tá",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Óra Nỹvuru tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Óra Nẽpar tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Óra Paravu tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Óra Pã Samãva tá",
               "SST",
               "Rỹ Kã óra Samãva tá",
               "SST",
               "Óra Samãva tá",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Óra Siova tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Óra Pã Tãga tá",
               "",
               "Rỹ Kã óra Tãga tá",
               "",
               "Óra Tãga tá",
               "",
            };
        final String[] Alaska = new String[] {
               "Óra Pã Aranhka tá",
               "AKST",
               "Rỹ Kã óra Aranhka tá",
               "AKDT",
               "Aranhka tá óra",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Óra Pã Amỹjonỹ tá",
               "AMT",
               "Rỹ Kã óra Amỹjonỹ tá",
               "AMST",
               "Amỹjonỹ tá óra",
               "AMT",
            };
        final String[] Anadyr = new String[] {
               "Óra Pã Anỹnhyr tá",
               "",
               "Rỹ Kã óra Anỹnhyr tá",
               "",
               "Óra Anỹnnyr tá",
               "",
            };
        final String[] Azores = new String[] {
               "Óra Pã Asor-ag tá",
               "",
               "Rỹ Kã óra Aso-ag tá",
               "",
               "Óra Asor-ag tá",
               "",
            };
        final String[] Bhutan = new String[] {
               "Óra Mutỹv tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Óra Mrunẽj Narusarỹ tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Óra Pã Panhkuva Goj-vẽso tá",
               "",
               "Rỹ Kã óra Panhkuva Goj-vẽso tá",
               "",
               "Óra Panhkuva Goj-vẽso tá",
               "",
            };
        final String[] Guyana = new String[] {
               "Óra Gijỹnỹ tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Óra Pã Isihaé tá",
               "IST",
               "Rỹ Kã óra Isihaé tá",
               "IDT",
               "Óra Isihaé tá",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Óra de Kosiraje tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Óra Mỹusãn tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Óra Pã Mãnhkov tá",
               "MSK",
               "Rỹ Kã óra Mãnhkov tá",
               "MSK",
               "Óra Mãnhkov tá",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Óra Ponỹpe tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Óra Pã Samỹra tá",
               "",
               "Rỹ Kã óra Samỹra tá",
               "",
               "Óra Samỹra tá",
               "",
            };
        final String[] Tahiti = new String[] {
               "Óra Tajti tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Óra Pã Tajpej tá",
               "CST",
               "Rỹ Kã óra Tajpej tá",
               "CDT",
               "Óra Tajpej tá",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Óra Tuvaru tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Óra Vonhtóki tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Óra Varinh kar Futunỹ tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Óra Pã Aramija tá",
               "",
               "Rỹ Kã óra Aramija tá",
               "",
               "Óra Aramija tá",
               "",
            };
        final String[] Armenia = new String[] {
               "Óra Pã Armẽnĩja tá",
               "",
               "Rỹ Kã óra Armẽnĩja tá",
               "",
               "Óra Armẽnĩja tá",
               "",
            };
        final String[] Bolivia = new String[] {
               "Óra Morivia tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Óra Pã San-hỹm tá",
               "",
               "Rỹ Kã óra San-hỹm tá",
               "",
               "Óra San-hỹm tá",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Ga-kar Óra Vẽnh-krén-ja",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Óra Ekuvanor tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Óra Gỹmmijer",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Óra Pã Jeórja tá",
               "",
               "Rỹ Kã óra Jeórja tá",
               "",
               "Óra Jeórja tá",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Óra Pã Irkutinhki tá",
               "",
               "Rỹ Kã óra Irkutinhki tá",
               "",
               "Óra Irkutinhki tá",
               "",
            };
        final String[] Magadan = new String[] {
               "Óra Pã Mỹganan tá",
               "",
               "Rỹ Kã óra Mỹganan tá",
               "",
               "Óra Mỹganan tá",
               "",
            };
        final String[] Myanmar = new String[] {
               "Óra Mĩjỹmỹr tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Óra Pã Nãrforki Goj-vẽso tá",
               "",
               "Rỹ Kã óra Nãrforki Goj-vẽso tá",
               "",
               "Óra Nãrforki Goj-vẽso tá",
               "",
            };
        final String[] Noronha = new String[] {
               "Óra Pã Fernỹnu Nãrãja-tá tá",
               "",
               "Rỹ Kã óra Fernỹnu Nãrãja-tá tá",
               "",
               "Óra Fernỹnu Nãrãja-tá tá",
               "",
            };
        final String[] Reunion = new String[] {
               "Óra Hujáv tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Óra Rotera tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Óra Saromỹv Goj-vẽso tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Óra Tokeravu tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Óra Pã Uruguvaj tá",
               "",
               "Rỹ Kã óra Uruguvaj tá",
               "",
               "Óra Uruguvaj tá",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Óra Pã Vanũvatu tá",
               "",
               "Rỹ Kã óra Vanũvatu tá",
               "",
               "Óra Vanũvatu tá",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Óra Pã Yjakutinhkii tá",
               "",
               "Rỹ Kã óra Yjakutinhki tá",
               "",
               "Óra Yjakutinhki tá",
               "",
            };
        final String[] Atlantic = new String[] {
               "Óra Pã Atrỹtiku tá",
               "AST",
               "Rỹ Kã óra Atrỹtiku tá",
               "AST",
               "Óra Atrỹtiku tá",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Óra Pã Mrasirja tá",
               "BRT",
               "Rỹ Kã óra Mrasirja tá",
               "BRST",
               "Óra Mrasirja tá",
               "BRT",
            };
        final String[] Chamorro = new String[] {
               "Óra Samãho tá",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Óra Pã Korãmija tá",
               "",
               "Rỹ Kã óra Korãmija tá",
               "",
               "Óra Korãmija tá",
               "",
            };
        final String[] Falkland = new String[] {
               "Ór Pã Mỹrvĩnỹ Goj-vẽso tá",
               "",
               "Rỹ Kã óra Mỹrvĩnỹ Goj-vẽso tá",
               "",
               "Óra Mỹrvĩnỹ Goj-vẽso tá",
               "",
            };
        final String[] Malaysia = new String[] {
               "Óra Mỹraja tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Óra Goj Vẽso Mỹrniva tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Óra Pã Uran Mator tá",
               "",
               "Rỹ Kã óra Uran Mator tá",
               "",
               "Óra Uran Mator tá",
               "",
            };
        final String[] Pakistan = new String[] {
               "Óra Pã Pakinhtỹv tá",
               "PKT",
               "Rỹ Kã óra Pakinhtỹv tá",
               "PKST",
               "Óra Pakinhtỹv tá",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Óra Pã Paraguvaj tá",
               "",
               "Rỹ Kã óra Paraguvaj tá",
               "",
               "Óra Paraguvaj tá",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Óra Pinkajir Goj-vẽso tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Óra Pã Sakarinỹ tá",
               "",
               "Rỹ Kã óra Sakarinỹ tá",
               "",
               "Óra Sakarinỹ tá",
               "",
            };
        final String[] Suriname = new String[] {
               "Óra Surinỹmĩ tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Óra Opã Arjẽtĩnỹ tá",
               "",
               "Rỹ Kã óra Arjẽtĩnỹ tá",
               "",
               "Óra Arjẽtĩnỹ tá",
               "",
            };
        final String[] Christmas = new String[] {
               "Óra Krĩtimỹnh Goj-vẽso tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Óra Gara Pago tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Óra Pã Hãg Kãg tá",
               "HKT",
               "Rỹ Kã óra Hãg Kãg tá",
               "HKST",
               "Óra Hãg Kãg tá",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Óra Ĩnosĩnỹ tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Óra Pã Petrupaviróvinhki-Kỹmsatinhki",
               "",
               "Rỹ Kã óra Petrupaviróvinhki-Kỹmsatinhki",
               "",
               "Óra Petrupaviróvinhki-Kỹmsatinhki",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Óra Kirginhtỹv tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Óra Pã Rórni Hove tá",
               "",
               "Rỹ Kã óra Rórni Hove tá",
               "",
               "Óra Rórni Hove tá",
               "",
            };
        final String[] Marquesas = new String[] {
               "Óra Mỹrkeja Fag tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Óra Pã Mãriso tá",
               "",
               "Rỹ Kã óra Mãriso tá",
               "",
               "Óra Mãriso tá",
               "",
            };
        final String[] Singapore = new String[] {
               "Óra Pã Sĩgapura tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Óra Venẽjuvéra tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Óra Pã Vorgugrano tá",
               "MSK",
               "Rỹ Kã óra Vorgugrano tá",
               "MSK",
               "Óra Vorgugrano tá",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Óra Pã Ajermajjáv tá",
               "",
               "Rỹ Kã óra Ajermajjáv tá",
               "",
               "Óra Ajermajjáv tá",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Óra Pã Mỹngranési tá",
               "",
               "Rỹ Kã óra Mỹngranési tá",
               "",
               "Óra Mỹngranési tá",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Óra Pã Pu Tánh tá",
               "",
               "Rỹ Kã óra Pu tánh tá",
               "",
               "Óra Pu Tánh tá",
               "",
            };
        final String[] East_Timor = new String[] {
               "Óra Tĩmãr-Rãjur tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Óra Sejserenh tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Óra Tajikinhtỹv tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Óra Pã Unnmekinhtỹv tá",
               "",
               "Rỹ Kã óra Unhmekinhtỹv tá",
               "",
               "Óra Unhmekinhtỹv tá",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afeganĩtã tá óra",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Óra Pã Kranhnãjarki tá",
               "",
               "Rỹ Kã óra Kranhnãjarki tá",
               "",
               "Óra Kranhnãjarki tá",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Óra Pã Jerỹnija Tãg tá",
               "NZST",
               "Rỹ Kã óra Jerỹnija Tãg tá",
               "NZDT",
               "Óra Jerỹnija Tãg tá",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Óra Pã Simirsiki Tãg tá",
               "",
               "Rỹ Kã óra Pã Simirsiki Tãg tá",
               "",
               "Óra Simirsiki Tãg tá",
               "",
            };
        final String[] Philippines = new String[] {
               "Óra Pã Firipinỹ tá",
               "PST",
               "Rỹ Kã Firipinỹ tá",
               "PDT",
               "Óra Firipinỹ tá",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Óra Pã Uranivónhtóki tá",
               "",
               "Rỹ Kã óra Uranivónhtóki tá",
               "",
               "Óra Uranivónhtókii tá",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Óra Osiỹno Ĩniko tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Óra Vãfe Goj-vẽso tỹ tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Óra Pã Ga Tãg tá",
               "NST",
               "Rỹ Kã óra Ga Tãg tá",
               "NDT",
               "Óra Ga tãg tá",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Óra Pã Turkomẽnĩnhtỹv tá",
               "",
               "Rỹ Kã óra Turkomẽnĩnhtỹv tá",
               "",
               "Óra Turkomẽnĩnhtỹv tá",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Óra Frỹsa Gijanỹ tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Óra Pã Karenonĩja Tãg tá",
               "",
               "Rỹ Kã óra Karenonĩja Tãg tá",
               "",
               "Óra Karenonĩja Tãg tá",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Óra Jiórja tỹ Sur tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Óra Pã Ekaterĩnmurgu tá",
               "",
               "Rỹ Kã óra Ekaterĩnmurgu tá",
               "",
               "Óra Ekaterĩnmurgu tá",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Afrika-Kuju tá óra",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Afrika Rãjur tá óra",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Óra Pã Afrika Rãpur tá",
               "WAT",
               "Rỹ Kã óra Afrika Rãpur tá",
               "WAT",
               "Afrika Rãpur tá óra",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Óra Numã-Nurviri tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Óra Pã Orópa Kuju tá",
               "CET",
               "Rỹ Kã óra Orópa Kuju tá",
               "CEST",
               "Óra Orópa Kuju tá",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Óra Pã Orópa Rãjur tá",
               "EET",
               "Rỹ Kã óra Orópa Rãjur tá",
               "EEST",
               "Óra Orópa Rãjur tá",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Óra Pã Orópa Rãpur tá",
               "WET",
               "Rỹ Kã óra Orópa Rãpur tá",
               "WEST",
               "Óra Orópa Rãpur tá",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Óra Pã Mẽsiku Pasifiku tá",
               "MST",
               "Rỹ Kã óra Mẽsiku Pasifiku tá",
               "MDT",
               "Óra Mẽsiku Pasifiku tá",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Sur-Afrika tá óra",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Óra Pã Kuju tá",
               "CST",
               "Rỹ Kã óra Kuju tá",
               "CDT",
               "Kuju tá óra",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Óra Pã Rãjur tá",
               "EST",
               "Rỹ Kã óra Rãjur tá",
               "EST",
               "Óra Rãjur tá",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Óra Pã Rãpur tá",
               "PST",
               "Rỹ Kã óra Rãpur tá",
               "PDT",
               "Óra Rãpur tá",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Óra Frỹsa Ga Sur kar Ỹtartina tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Óra Jirmértu Goj-vẽso tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Óra Pã Hava’i kar Arevta Goj-vẽso tá",
               "HST",
               "Rỹ kã óra Hava’i kar Arevta Goj-vẽso tá",
               "HST",
               "Óra Hava’i kar Arevta Goj-vẽso tá",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Óra Fẽnĩg Goj-vẽso tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Óra Pã Sỹ Pedro kar Mĩkerỹv tá",
               "",
               "Rỹ Kã óra Sỹ Pedro kar Mĩkerỹv tá",
               "",
               "Óra Sỹ Penru kar Mĩkerỹv tá",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Óra Pã Krĩ tá",
               "MST",
               "Rỹ Kã óra Krĩ tá",
               "MST",
               "Óra Krĩ tá",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Óra MỹrSar Goj-vẽso tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Óra Papuva-Ginẽ Tãg tá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Óra Pã Avotyraria Kuju tá",
               "ACST",
               "Rỹ Kã óra Avotyraria Kuju tá",
               "ACDT",
               "Óra Avotyraria Kuju tá",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Óra Pã Avotyraria Rãjur tá",
               "AEST",
               "Rỹ Kã óra Avotyraria Rãjur tá",
               "AEDT",
               "Óra Avotyraria Rãjur tá",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Óra Pã Avotyraria Rãpur tá",
               "AWST",
               "Rỹ Kã óra Avotyraria Rãpur tá",
               "AWDT",
               "Óra Avotyraria Rãpur tá",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Óra Ĩnonẽja Kuju tá",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Óra Ĩnonẽja Rãjur tá",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Óra Ĩnonẽja Rãpur tá",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Óra Pã Avotyraria Kuju-Rãpur tá",
               "",
               "Rỹ Kã óra Avotyraria Kuju-Rãpur tá",
               "",
               "Óra Avotyaria Kuju-Rãpur tá",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Óra Mirinjỹnũ Grinũvisi tá",
                    "GMT",
                    "Óra Mritỹnĩku Rỹ Kã",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Ga-kar Óra Vẽnh-krén-ja",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Óra Mirinjỹnũ Grinũvisi tá",
                    "GMT",
                    "Óra Pã Irỹna",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Ga-kar Óra Vẽnh-krén-ja",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Ga-kar Óra Vẽnh-krén-ja",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Óra Mirinjỹnũ Grinũvisi tá",
                    "GMT",
                    "Óra Mritỹnĩku Rỹ Kã",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Ga-kar Óra Vẽnh-krén-ja",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Ga-kar Óra Vẽnh-krén-ja",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Ga-kar Óra Vẽnh-krén-ja",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Óra Mirinjỹnũ Grinũvisi tá",
                    "GMT",
                    "Óra Pã Irỹna",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Óra Mirinjỹnũ Grinũvisi tá",
                    "GMT",
                    "Óra Mritỹnĩku Rỹ Kã",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Óra Mirinjỹnũ Grinũvisi tá",
                    "GMT",
                    "Óra Mritỹnĩku Rỹ Kã",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Óra Mirinjỹnũ Grinũvisi tá",
                    "GMT",
                    "Óra Mritỹnĩku Rỹ Kã",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Óra Mirinjỹnũ Grinũvisi tá",
                    "GMT",
                    "Óra Mritỹnĩku Rỹ Kã",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Óra Mirinjỹnũ Grinũvisi tá",
                    "GMT",
                    "Óra Mritỹnĩku Rỹ Kã",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Anen" },
            { "timezone.excity.Asia/Baku", "Maku" },
            { "timezone.excity.Asia/Dili", "Niri" },
            { "timezone.excity.Asia/Gaza", "Gaja" },
            { "timezone.excity.Asia/Hovd", "Hovin" },
            { "timezone.excity.Asia/Omsk", "Omĩnhki" },
            { "timezone.excity.Asia/Oral", "Orar" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amỹ" },
            { "timezone.excity.Asia/Aqtau", "Akitau" },
            { "timezone.excity.Asia/Chita", "Sita" },
            { "timezone.excity.Asia/Dhaka", "Naka" },
            { "timezone.excity.Asia/Dubai", "Numaj" },
            { "timezone.excity.Asia/Kabul", "Kamur" },
            { "timezone.excity.Asia/Macau", "Mỹkau" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Se’ur" },
            { "timezone.excity.Asia/Tokyo", "Tókijo" },
            { "timezone.excity.Asia/Tomsk", "Tomĩnhki" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Juma" },
            { "timezone.excity.Africa/Lome", "Rómẽ" },
            { "timezone.excity.Asia/Almaty", "Armỹti" },
            { "timezone.excity.Asia/Anadyr", "Anỹnhir" },
            { "timezone.excity.Asia/Aqtobe", "Akitome" },
            { "timezone.excity.Asia/Atyrau", "Atirav" },
            { "timezone.excity.Asia/Beirut", "Mejruti" },
            { "timezone.excity.Asia/Brunei", "Mrunẽj" },
            { "timezone.excity.Asia/Hebron", "Hemron" },
            { "timezone.excity.Asia/Kuwait", "Kuvajti" },
            { "timezone.excity.Asia/Manila", "Mỹnĩra" },
            { "timezone.excity.Asia/Riyadh", "Rijane" },
            { "timezone.excity.Asia/Taipei", "Tajpej" },
            { "timezone.excity.Asia/Tehran", "Te’erỹ" },
            { "timezone.excity.Asia/Urumqi", "Urũmki" },
            { "timezone.excity.Etc/Unknown", "Jamã Vejatũ" },
            { "timezone.excity.Europe/Kiev", "Kijévi" },
            { "timezone.excity.Europe/Oslo", "Ósiro" },
            { "timezone.excity.Europe/Rome", "Romỹ" },
            { "timezone.excity.Indian/Mahe", "Mỹhé" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Africa/Cairo", "Kajro" },
            { "timezone.excity.Africa/Ceuta", "Sevuta" },
            { "timezone.excity.Africa/Dakar", "Nakar" },
            { "timezone.excity.Africa/Lagos", "Rago" },
            { "timezone.excity.Africa/Tunis", "Tunĩnh" },
            { "timezone.excity.America/Adak", "Anaki" },
            { "timezone.excity.America/Lima", "Rimỹ" },
            { "timezone.excity.America/Nome", "Jyjy" },
            { "timezone.excity.Asia/Baghdad", "Magina" },
            { "timezone.excity.Asia/Bahrain", "Marẽj" },
            { "timezone.excity.Asia/Bangkok", "Mygkóki" },
            { "timezone.excity.Asia/Barnaul", "Marnỹur" },
            { "timezone.excity.Asia/Bishkek", "Misikéki" },
            { "timezone.excity.Asia/Colombo", "Korãmmu" },
            { "timezone.excity.Asia/Irkutsk", "Irkutinhki" },
            { "timezone.excity.Asia/Karachi", "Karasi" },
            { "timezone.excity.Asia/Kuching", "Kusĩg" },
            { "timezone.excity.Asia/Magadan", "Mỹganan" },
            { "timezone.excity.Asia/Nicosia", "Nĩkójia" },
            { "timezone.excity.Asia/Rangoon", "Rangũm" },
            { "timezone.excity.Asia/Tbilisi", "Timiriji" },
            { "timezone.excity.Asia/Thimphu", "Tĩmfu" },
            { "timezone.excity.Asia/Yakutsk", "Yjakutinhki" },
            { "timezone.excity.Asia/Yerevan", "Jerevỹ" },
            { "timezone.excity.Europe/Kirov", "Kiróvi" },
            { "timezone.excity.Europe/Malta", "Marta" },
            { "timezone.excity.Europe/Minsk", "Mĩgsiki" },
            { "timezone.excity.Europe/Paris", "Parinh" },
            { "timezone.excity.Europe/Sofia", "Sófija" },
            { "timezone.excity.Europe/Vaduz", "Vanuj" },
            { "timezone.excity.Indian/Cocos", "Kóko Ag" },
            { "timezone.excity.Pacific/Apia", "Apija" },
            { "timezone.excity.Pacific/Guam", "Guvỹm" },
            { "timezone.excity.Pacific/Niue", "Nĩve" },
            { "timezone.excity.Pacific/Wake", "Vaki" },
            { "timezone.excity.Africa/Asmera", "Asimỹra" },
            { "timezone.excity.Africa/Bamako", "Mamỹko" },
            { "timezone.excity.Africa/Bangui", "Magi" },
            { "timezone.excity.Africa/Banjul", "Manjur" },
            { "timezone.excity.Africa/Bissau", "Misav" },
            { "timezone.excity.Africa/Douala", "Novara" },
            { "timezone.excity.Africa/Harare", "Harari" },
            { "timezone.excity.Africa/Kigali", "Kigari" },
            { "timezone.excity.Africa/Luanda", "Ruvỹna" },
            { "timezone.excity.Africa/Lusaka", "Rusaka" },
            { "timezone.excity.Africa/Malabo", "Mỹramo" },
            { "timezone.excity.Africa/Maputo", "Mỹputu" },
            { "timezone.excity.Africa/Maseru", "Mỹseru" },
            { "timezone.excity.Africa/Niamey", "Nĩamẽj" },
            { "timezone.excity.America/Aruba", "Aruma" },
            { "timezone.excity.America/Bahia", "Majia" },
            { "timezone.excity.America/Belem", "Merẽj" },
            { "timezone.excity.America/Boise", "Mojse" },
            { "timezone.excity.America/Jujuy", "Jujuj" },
            { "timezone.excity.America/Sitka", "Sinka" },
            { "timezone.excity.America/Thule", "Ture" },
            { "timezone.excity.Asia/Ashgabat", "Anhgamati" },
            { "timezone.excity.Asia/Calcutta", "Karkuta" },
            { "timezone.excity.Asia/Damascus", "Namỹnhko" },
            { "timezone.excity.Asia/Dushanbe", "Nuságme" },
            { "timezone.excity.Asia/Jayapura", "Jaiapura" },
            { "timezone.excity.Asia/Katmandu", "Katimỹnnu" },
            { "timezone.excity.Asia/Khandyga", "Kỹnyga" },
            { "timezone.excity.Asia/Qostanay", "Kojtanỹj" },
            { "timezone.excity.Asia/Sakhalin", "Sakarĩnỹ" },
            { "timezone.excity.Asia/Shanghai", "Sỹggaj" },
            { "timezone.excity.Asia/Tashkent", "Tanhkẽnti" },
            { "timezone.excity.Asia/Ust-Nera", "Unhti-Nẽra" },
            { "timezone.excity.Europe/Athens", "Atenỹ" },
            { "timezone.excity.Europe/Berlin", "Mer-rĩg" },
            { "timezone.excity.Europe/Dublin", "Numrin" },
            { "timezone.excity.Europe/Jersey", "Jérsej" },
            { "timezone.excity.Europe/Lisbon", "Rinhmova" },
            { "timezone.excity.Europe/London", "Rãnere" },
            { "timezone.excity.Europe/Madrid", "Mỹniri" },
            { "timezone.excity.Europe/Monaco", "Mãnỹko" },
            { "timezone.excity.Europe/Moscow", "Mãnhkov" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Samara", "Samỹra" },
            { "timezone.excity.Europe/Skopje", "Sikopije" },
            { "timezone.excity.Europe/Tirane", "Tirỹnỹ" },
            { "timezone.excity.Europe/Vienna", "Vienỹ" },
            { "timezone.excity.Europe/Warsaw", "Varsóvija" },
            { "timezone.excity.Europe/Zagreb", "Jagréme" },
            { "timezone.excity.Europe/Zurich", "Jurike" },
            { "timezone.excity.Indian/Chagos", "Sago" },
            { "timezone.excity.Indian/Comoro", "Komãre" },
            { "timezone.excity.Pacific/Efate", "Éfaté" },
            { "timezone.excity.Pacific/Nauru", "Nỹvuru" },
            { "timezone.excity.Pacific/Palau", "Parav" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Aminjan" },
            { "timezone.excity.Africa/Algiers", "Arjér" },
            { "timezone.excity.Africa/Conakry", "Konỹkri" },
            { "timezone.excity.Africa/Kampala", "Kãmpara" },
            { "timezone.excity.Africa/Mbabane", "Mĩmamanẽ" },
            { "timezone.excity.Africa/Nairobi", "Nỹjrómi" },
            { "timezone.excity.Africa/Tripoli", "Tripori" },
            { "timezone.excity.America/Belize", "Merise" },
            { "timezone.excity.America/Bogota", "Mogota" },
            { "timezone.excity.America/Cancun", "Kỹkũn" },
            { "timezone.excity.America/Cayman", "Kajmỹn" },
            { "timezone.excity.America/Cuiaba", "Kujama" },
            { "timezone.excity.America/Dawson", "Navsãn" },
            { "timezone.excity.America/Denver", "Nenver" },
            { "timezone.excity.America/Guyana", "Gujánỹ" },
            { "timezone.excity.America/Havana", "Havánỹ" },
            { "timezone.excity.America/Inuvik", "Inũviki" },
            { "timezone.excity.America/Juneau", "Junỹvo" },
            { "timezone.excity.America/La_Paz", "Ra Pasi" },
            { "timezone.excity.America/Maceio", "Mỹsejó" },
            { "timezone.excity.America/Manaus", "Mỹnỹvo" },
            { "timezone.excity.America/Merida", "Mẽrina" },
            { "timezone.excity.America/Nassau", "Nỹsav" },
            { "timezone.excity.America/Panama", "Panỹmỹ" },
            { "timezone.excity.America/Recife", "Risifi" },
            { "timezone.excity.America/Regina", "Rijinỹ" },
            { "timezone.excity.Asia/Famagusta", "Famỹgujta" },
            { "timezone.excity.Asia/Hong_Kong", "Hãg Kãg" },
            { "timezone.excity.Asia/Jerusalem", "Jerujarẽj" },
            { "timezone.excity.Asia/Kamchatka", "Kỹmsanka" },
            { "timezone.excity.Asia/Pontianak", "Pãntiỹnỹki" },
            { "timezone.excity.Asia/Pyongyang", "Piãg-jỹg" },
            { "timezone.excity.Asia/Qyzylorda", "Kyjyrorna" },
            { "timezone.excity.Asia/Samarkand", "Samỹrkỹnna" },
            { "timezone.excity.Asia/Singapore", "Sĩgapura" },
            { "timezone.excity.Asia/Vientiane", "Vijẽtijỹnĩ" },
            { "timezone.excity.Europe/Andorra", "Ỹnoha" },
            { "timezone.excity.Europe/Saratov", "Saratóvi" },
            { "timezone.excity.Europe/Tallinn", "Tarĩn" },
            { "timezone.excity.Europe/Vatican", "Vatikỹnũ" },
            { "timezone.excity.Europe/Vilnius", "Virnĩjusi" },
            { "timezone.excity.Indian/Mayotte", "Mỹjóti" },
            { "timezone.excity.Indian/Reunion", "Rũnjũv" },
            { "timezone.excity.Pacific/Easter", "Pasikuva Goj-vẽso" },
            { "timezone.excity.Pacific/Kosrae", "Kosiraje" },
            { "timezone.excity.Pacific/Majuro", "Mỹjuro" },
            { "timezone.excity.Pacific/Midway", "Mĩnnuvej" },
            { "timezone.excity.Pacific/Noumea", "Nãumẽa" },
            { "timezone.excity.Pacific/Saipan", "Sajpỹ" },
            { "timezone.excity.Pacific/Tahiti", "Tajti" },
            { "timezone.excity.Pacific/Tarawa", "Tarauva" },
            { "timezone.excity.Pacific/Wallis", "Varinh" },
            { "timezone.excity.Africa/Blantyre", "Mrantyre" },
            { "timezone.excity.Africa/Djibouti", "Nhimuti" },
            { "timezone.excity.Africa/El_Aaiun", "Er A’ajun" },
            { "timezone.excity.Africa/Freetown", "Ẽmã-fri" },
            { "timezone.excity.Africa/Gaborone", "Gamoronĩ" },
            { "timezone.excity.Africa/Khartoum", "Kartũm" },
            { "timezone.excity.Africa/Kinshasa", "Kĩsaja" },
            { "timezone.excity.Africa/Monrovia", "Mãnróvija" },
            { "timezone.excity.Africa/Ndjamena", "Ni’nijamẽnỹ" },
            { "timezone.excity.Africa/Sao_Tome", "Sỹ Tumẽ" },
            { "timezone.excity.Africa/Windhoek", "Vĩnnoéki" },
            { "timezone.excity.America/Antigua", "Ỹtiguva" },
            { "timezone.excity.America/Caracas", "Karakanh" },
            { "timezone.excity.America/Cayenne", "Kajenỹ" },
            { "timezone.excity.America/Chicago", "Sikagu" },
            { "timezone.excity.America/Cordoba", "Kórnoma" },
            { "timezone.excity.America/Creston", "Krésitãn" },
            { "timezone.excity.America/Curacao", "Kurasavo" },
            { "timezone.excity.America/Detroit", "Netorójti" },
            { "timezone.excity.America/Godthab", "Nũg" },
            { "timezone.excity.America/Grenada", "Granỹna" },
            { "timezone.excity.America/Halifax", "Harifag" },
            { "timezone.excity.America/Iqaluit", "Ikarujin" },
            { "timezone.excity.America/Jamaica", "Jamỹjkỹ" },
            { "timezone.excity.America/Managua", "Mỹnỹguva" },
            { "timezone.excity.America/Marigot", "Mỹrigóti" },
            { "timezone.excity.America/Mendoza", "Mẽnosa" },
            { "timezone.excity.America/Moncton", "Mãgtãn" },
            { "timezone.excity.America/Noronha", "Fernỹnu Nãrãja-tá" },
            { "timezone.excity.America/Ojinaga", "Ojinỹga" },
            { "timezone.excity.America/Phoenix", "Fuenĩnh" },
            { "timezone.excity.America/Tijuana", "Tivỹnỹ" },
            { "timezone.excity.America/Toronto", "Torãto" },
            { "timezone.excity.America/Tortola", "Tortora" },
            { "timezone.excity.America/Yakutat", "Yjakutati" },
            { "timezone.excity.Asia/Phnom_Penh", "Fynãg Pẽj" },
            { "timezone.excity.Atlantic/Azores", "Asorenh" },
            { "timezone.excity.Atlantic/Canary", "Kanỹrija Ag" },
            { "timezone.excity.Australia/Eucla", "Eukra" },
            { "timezone.excity.Australia/Perth", "Pérti" },
            { "timezone.excity.Europe/Belgrade", "Mergrano" },
            { "timezone.excity.Europe/Brussels", "Mruséra" },
            { "timezone.excity.Europe/Budapest", "Munapenhte" },
            { "timezone.excity.Europe/Busingen", "Myjingen" },
            { "timezone.excity.Europe/Chisinau", "Sijinỹvo" },
            { "timezone.excity.Europe/Guernsey", "Gérnĩsej" },
            { "timezone.excity.Europe/Helsinki", "Hérsĩgke" },
            { "timezone.excity.Europe/Istanbul", "Inhtamur" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo/Sarajevu" },
            { "timezone.excity.Indian/Maldives", "Mỹrniva" },
            { "timezone.excity.Pacific/Chatham", "Satinỹm" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofu" },
            { "timezone.excity.Pacific/Gambier", "Gỹmmiér" },
            { "timezone.excity.Pacific/Norfolk", "Nãrfoki" },
            { "timezone.excity.Africa/Bujumbura", "Mujũmura" },
            { "timezone.excity.Africa/Mogadishu", "Mũganinhsu" },
            { "timezone.excity.America/Anguilla", "Ỹgira" },
            { "timezone.excity.America/Asuncion", "Asũgsỹ" },
            { "timezone.excity.America/Barbados", "Marmanu" },
            { "timezone.excity.America/Dominica", "Nomĩnĩka" },
            { "timezone.excity.America/Edmonton", "Enimãntã" },
            { "timezone.excity.America/Eirunepe", "Ejrunẽpé" },
            { "timezone.excity.America/Mazatlan", "Mỹjatrỹn" },
            { "timezone.excity.America/Miquelon", "Mĩkeron" },
            { "timezone.excity.America/New_York", "Yjórki Tãg" },
            { "timezone.excity.America/Resolute", "Rijorute" },
            { "timezone.excity.America/Santarem", "Sỹtarẽj" },
            { "timezone.excity.America/Santiago", "Sỹtijagu" },
            { "timezone.excity.America/St_Johns", "Sỹn Jonh" },
            { "timezone.excity.America/St_Kitts", "Sỹ Kritóvỹ" },
            { "timezone.excity.America/St_Lucia", "Sỹta Rusa" },
            { "timezone.excity.America/Winnipeg", "Vĩnĩpég" },
            { "timezone.excity.Antarctica/Casey", "Kasej" },
            { "timezone.excity.Antarctica/Davis", "Navisi" },
            { "timezone.excity.Antarctica/Syowa", "Siova" },
            { "timezone.excity.Antarctica/Troll", "Torór" },
            { "timezone.excity.Asia/Krasnoyarsk", "Kranhnãjarki" },
            { "timezone.excity.Asia/Novosibirsk", "Simirsiki Tãg" },
            { "timezone.excity.Asia/Ulaanbaatar", "Uran Mator" },
            { "timezone.excity.Asia/Vladivostok", "Uranivónhtóki" },
            { "timezone.excity.Atlantic/Bermuda", "Mermũna" },
            { "timezone.excity.Atlantic/Madeira", "Ka" },
            { "timezone.excity.Atlantic/Stanley", "Sitỹrej" },
            { "timezone.excity.Australia/Darwin", "Narvĩn" },
            { "timezone.excity.Australia/Hobart", "Homarti" },
            { "timezone.excity.Australia/Sydney", "Sininej" },
            { "timezone.excity.Europe/Amsterdam", "Amĩnhterná" },
            { "timezone.excity.Europe/Astrakhan", "Anhtakỹ" },
            { "timezone.excity.Europe/Bucharest", "Mukarénhti" },
            { "timezone.excity.Europe/Gibraltar", "Jimratar" },
            { "timezone.excity.Europe/Ljubljana", "Rimriỹnỹ" },
            { "timezone.excity.Europe/Mariehamn", "Mỹriehỹm" },
            { "timezone.excity.Europe/Podgorica", "Pongórika" },
            { "timezone.excity.Europe/Stockholm", "Enhtukormũ" },
            { "timezone.excity.Europe/Ulyanovsk", "Urijanãvinhki" },
            { "timezone.excity.Europe/Volgograd", "Vorgugrano" },
            { "timezone.excity.Indian/Christmas", "Krinhtimỹ" },
            { "timezone.excity.Indian/Kerguelen", "Kirgéren" },
            { "timezone.excity.Indian/Mauritius", "Mãrisiv" },
            { "timezone.excity.Pacific/Auckland", "Óg-rỹn" },
            { "timezone.excity.Pacific/Funafuti", "Funỹfuti" },
            { "timezone.excity.Pacific/Honolulu", "Honãruru" },
            { "timezone.excity.Pacific/Pitcairn", "Pitikair" },
            { "timezone.excity.Africa/Casablanca", "Ĩnkupri" },
            { "timezone.excity.Africa/Libreville", "Rimreviri" },
            { "timezone.excity.Africa/Lubumbashi", "Rumumasi" },
            { "timezone.excity.Africa/Nouakchott", "Nãvagsóti" },
            { "timezone.excity.Africa/Porto-Novo", "Porto Tãg" },
            { "timezone.excity.America/Anchorage", "Ỹkoragi" },
            { "timezone.excity.America/Araguaina", "Araguainỹ" },
            { "timezone.excity.America/Boa_Vista", "Veja Há" },
            { "timezone.excity.America/Catamarca", "Katamỹrka" },
            { "timezone.excity.America/Chihuahua", "Sihuvahuva" },
            { "timezone.excity.America/Fortaleza", "Fortareja" },
            { "timezone.excity.America/Glace_Bay", "Grase Mej" },
            { "timezone.excity.America/Goose_Bay", "Gỹso Mej" },
            { "timezone.excity.America/Guatemala", "Guratemỹra" },
            { "timezone.excity.America/Guayaquil", "Guvajakir" },
            { "timezone.excity.America/Matamoros", "Mãro-ag Tãnh" },
            { "timezone.excity.America/Menominee", "Mẽnãmĩnĩ" },
            { "timezone.excity.America/Monterrey", "Mãtehej" },
            { "timezone.excity.America/Sao_Paulo", "Sỹ Pavoru" },
            { "timezone.excity.America/St_Thomas", "Sỹ Tomaj" },
            { "timezone.excity.America/Vancouver", "Vỹgkuver" },
            { "timezone.excity.Antarctica/Mawson", "Mỹusãn" },
            { "timezone.excity.Antarctica/Palmer", "Parmẽr" },
            { "timezone.excity.Antarctica/Vostok", "Vonhtóki" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuvara Rũpur" },
            { "timezone.excity.Asia/Novokuznetsk", "Kunhnẽtinhki Tãg" },
            { "timezone.excity.Europe/Bratislava", "Mratinhrava" },
            { "timezone.excity.Europe/Copenhagen", "Kopẽnhỹge" },
            { "timezone.excity.Europe/Luxembourg", "Rusẽgmurgo" },
            { "timezone.excity.Europe/San_Marino", "Sỹ Mỹrĩnũ" },
            { "timezone.excity.Europe/Simferopol", "Sĩgfiripor" },
            { "timezone.excity.Pacific/Enderbury", "Ẽnnermuri" },
            { "timezone.excity.Pacific/Galapagos", "Gara Pago" },
            { "timezone.excity.Pacific/Kwajalein", "Kuvajarẽj" },
            { "timezone.excity.Pacific/Marquesas", "Mỹrkeja Fag" },
            { "timezone.excity.Pacific/Rarotonga", "Rarãtãga" },
            { "timezone.excity.Pacific/Tongatapu", "Tãngatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Anisi Amema" },
            { "timezone.excity.Africa/Brazzaville", "Mrajavire" },
            { "timezone.excity.Africa/Ouagadougou", "Ovaganogov" },
            { "timezone.excity.America/Costa_Rica", "Pãnĩ Tũ Mág" },
            { "timezone.excity.America/Grand_Turk", "Turki Mág" },
            { "timezone.excity.America/Guadeloupe", "Guvanarupe" },
            { "timezone.excity.America/Hermosillo", "Hérmosiro" },
            { "timezone.excity.America/Kralendijk", "Krarẽnike" },
            { "timezone.excity.America/Louisville", "Ruinhviri" },
            { "timezone.excity.America/Martinique", "Mỹrtinĩka" },
            { "timezone.excity.America/Metlakatla", "Mẽtarakatara" },
            { "timezone.excity.America/Montevideo", "Mãtivinév" },
            { "timezone.excity.America/Montserrat", "Mãnseráti" },
            { "timezone.excity.America/Paramaribo", "Paramỹrimu" },
            { "timezone.excity.America/Rio_Branco", "Goj Kupri" },
            { "timezone.excity.America/St_Vincent", "Sỹ Visẽti" },
            { "timezone.excity.America/Whitehorse", "Kãvãru Kupri" },
            { "timezone.excity.Antarctica/McMurdo", "Még-Mũrno" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Srednekolymsk", "Sirenẽkorymsiki" },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterĩnmurgu" },
            { "timezone.excity.Atlantic/Reykjavik", "Rejkijaviki" },
            { "timezone.excity.Atlantic/St_Helena", "Sỹta Erenỹ" },
            { "timezone.excity.Australia/Adelaide", "Anerajni" },
            { "timezone.excity.Australia/Brisbane", "Mrinhmanẽ" },
            { "timezone.excity.Australia/Lindeman", "Rĩnermỹn" },
            { "timezone.excity.Europe/Isle_of_Man", "Ũn-gré Goj-vẽso" },
            { "timezone.excity.Europe/Kaliningrad", "Karinĩngrano" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimỹti" },
            { "timezone.excity.Africa/Johannesburg", "Juvỹnẽnhmurgu" },
            { "timezone.excity.America/El_Salvador", "Ér Sarvanor" },
            { "timezone.excity.America/Fort_Nelson", "Fórti Nẽrsu" },
            { "timezone.excity.America/Los_Angeles", "Ronh Ỹnjiri" },
            { "timezone.excity.America/Mexico_City", "Ẽmã tỹ Mẽsiko" },
            { "timezone.excity.America/Porto_Velho", "Porto Kófa" },
            { "timezone.excity.America/Puerto_Rico", "Porto Riko" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigarpa" },
            { "timezone.excity.Arctic/Longyearbyen", "Rũgijé Armyjẽn" },
            { "timezone.excity.Atlantic/Cape_Verde", "Pu Tánh" },
            { "timezone.excity.Australia/Lord_Howe", "Rórni Hove" },
            { "timezone.excity.Australia/Melbourne", "Mẽrmurnĩ" },
            { "timezone.excity.Indian/Antananarivo", "Ỹtanỹnỹrivo" },
            { "timezone.excity.Pacific/Guadalcanal", "Guvanarkanỹr" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Nar Enh Sarỹm" },
            { "timezone.excity.America/Blanc-Sablon", "Samrãn Kupri" },
            { "timezone.excity.America/Buenos_Aires", "Muenũsairi" },
            { "timezone.excity.America/Campo_Grande", "Re Mág" },
            { "timezone.excity.America/Danmarkshavn", "Nánmỹrkisavyn" },
            { "timezone.excity.America/Dawson_Creek", "Nausãn Kriki" },
            { "timezone.excity.America/Indiana/Knox", "Kinãg, Ĩnijỹnỹ" },
            { "timezone.excity.America/Indianapolis", "Ĩnijanỹporinh" },
            { "timezone.excity.America/Punta_Arenas", "Pũta Arenỹ" },
            { "timezone.excity.America/Rankin_Inlet", "Rỹgkĩg Ĩrén" },
            { "timezone.excity.America/Scoresbysund", "Itogkorturmĩnti" },
            { "timezone.excity.Antarctica/Macquarie", "Mỹkikuari" },
            { "timezone.excity.Pacific/Bougainville", "Mugỹnvire" },
            { "timezone.excity.Pacific/Port_Moresby", "Pór Mãrenhmi" },
            { "timezone.excity.America/Cambridge_Bay", "Kẽmrinje Mej" },
            { "timezone.excity.America/Coral_Harbour", "Atikokỹn" },
            { "timezone.excity.America/Indiana/Vevay", "Vevaj, Ĩnijỹnỹ" },
            { "timezone.excity.America/Lower_Princes", "Rover Prĩnsi Kuvartér" },
            { "timezone.excity.America/Port_of_Spain", "Pórtofi Inhpajin" },
            { "timezone.excity.America/Santo_Domingo", "Sỹtu Numĩggu" },
            { "timezone.excity.America/St_Barthelemy", "Sỹ Martoromẽ" },
            { "timezone.excity.America/Swift_Current", "Suvifiti Kurẽti" },
            { "timezone.excity.Australia/Broken_Hill", "Mruken Hir" },
            { "timezone.excity.America/Bahia_Banderas", "Majia Mánnera Ag" },
            { "timezone.excity.America/Port-au-Prince", "Portu Prĩsipi" },
            { "timezone.excity.Atlantic/South_Georgia", "Jiórja tỹ Sur" },
            { "timezone.excity.America/Argentina/Salta", "Sarta" },
            { "timezone.excity.America/Indiana/Marengo", "Mỹrẽggu, Ĩnijỹnỹ" },
            { "timezone.excity.America/Indiana/Winamac", "Vinỹmỹki, Ĩnijỹnỹ" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukumỹ" },
            { "timezone.excity.America/Argentina/Ushuaia", "Usuaja" },
            { "timezone.excity.America/Indiana/Tell_City", "Ter siti, Ĩnijỹnỹ" },
            { "timezone.excity.America/Indiana/Vincennes", "Vĩsenẽnh, Ĩnijỹnỹ" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ra Rioha" },
            { "timezone.excity.America/Argentina/San_Juan", "Sỹ Juvỹ" },
            { "timezone.excity.America/Argentina/San_Luis", "Sỹ Ruj" },
            { "timezone.excity.America/Indiana/Petersburg", "Pétermurgi, Ĩnijỹnỹ" },
            { "timezone.excity.America/Kentucky/Monticello", "Mãntiséru, Kẽtáki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Meura, Nakota Nãrti" },
            { "timezone.excity.America/North_Dakota/Center", "Sẽnter, Dakota Nãrti" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Garego Goj" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Nĩu Saren, Nakota Nãrti" },
        };
        return data;
    }
}
