// RUN: %clang_cc1 -triple x86_64-apple-darwin -O1 -no-struct-path-tbaa -disable-llvm-passes %s -emit-llvm -o - | FileCheck %s
// RUN: %clang_cc1 -triple x86_64-apple-darwin -O1 -disable-llvm-passes %s -emit-llvm -o - | FileCheck %s -check-prefixes=PATH,OLD-PATH
// RUN: %clang_cc1 -triple x86_64-apple-darwin -O1 -disable-llvm-passes %s -emit-llvm -new-struct-path-tbaa -o - | FileCheck %s -check-prefixes=PATH,NEW-PATH
// Test TBAA metadata generated by front-end.

typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
typedef unsigned long long uint64_t;
class StructA
{
public:
   uint16_t f16;
   uint32_t f32;
   uint16_t f16_2;
   uint32_t f32_2;
};
class StructB
{
public:
   uint16_t f16;
   StructA a;
   uint32_t f32;
};
class StructC
{
public:
   uint16_t f16;
   StructB b;
   uint32_t f32;
};
class StructD
{
public:
   uint16_t f16;
   StructB b;
   uint32_t f32;
   uint8_t f8;
};

class StructS
{
public:
   uint16_t f16;
   uint32_t f32;
};
class StructS2 : public StructS
{
public:
   uint16_t f16_2;
   uint32_t f32_2;
};

class StructT {
public:
  uint32_t f32_2;
  void foo();
};
class StructM1 : public StructS, public StructT {
public:
  uint16_t f16_2;
};
class StructDyn {
public:
  uint32_t f32_2;
  virtual void foo();
};
class StructM2 : public StructS, public StructDyn {
public:
  uint16_t f16_2;
};

uint32_t g(uint32_t *s, StructA *A, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z1g
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32:!.*]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// PATH-LABEL: define{{.*}} i32 @_Z1g
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32:!.*]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_A_f32:!.*]]
  *s = 1;
  A->f32 = 4;
  return *s;
}

uint32_t g2(uint32_t *s, StructA *A, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g2
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// CHECK: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i16:!.*]]
// PATH-LABEL: define{{.*}} i32 @_Z2g2
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// PATH: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TAG_A_f16:!.*]]
  *s = 1;
  A->f16 = 4;
  return *s;
}

uint32_t g3(StructA *A, StructB *B, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g3
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// PATH-LABEL: define{{.*}} i32 @_Z2g3
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_A_f32]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_B_a_f32:!.*]]
  A->f32 = 1;
  B->a.f32 = 4;
  return A->f32;
}

uint32_t g4(StructA *A, StructB *B, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g4
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// CHECK: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i16]]
// PATH-LABEL: define{{.*}} i32 @_Z2g4
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_A_f32]]
// PATH: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TAG_B_a_f16:!.*]]
  A->f32 = 1;
  B->a.f16 = 4;
  return A->f32;
}

uint32_t g5(StructA *A, StructB *B, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g5
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// PATH-LABEL: define{{.*}} i32 @_Z2g5
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_A_f32]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_B_f32:!.*]]
  A->f32 = 1;
  B->f32 = 4;
  return A->f32;
}

uint32_t g6(StructA *A, StructB *B, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g6
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// PATH-LABEL: define{{.*}} i32 @_Z2g6
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_A_f32]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_B_a_f32_2:!.*]]
  A->f32 = 1;
  B->a.f32_2 = 4;
  return A->f32;
}

uint32_t g7(StructA *A, StructS *S, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g7
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// PATH-LABEL: define{{.*}} i32 @_Z2g7
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_A_f32]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_S_f32:!.*]]
  A->f32 = 1;
  S->f32 = 4;
  return A->f32;
}

uint32_t g8(StructA *A, StructS *S, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g8
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// CHECK: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i16]]
// PATH-LABEL: define{{.*}} i32 @_Z2g8
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_A_f32]]
// PATH: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TAG_S_f16:!.*]]
  A->f32 = 1;
  S->f16 = 4;
  return A->f32;
}

uint32_t g9(StructS *S, StructS2 *S2, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g9
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// PATH-LABEL: define{{.*}} i32 @_Z2g9
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_S_f32]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_S_f32:!.*]]
  S->f32 = 1;
  S2->f32 = 4;
  return S->f32;
}

uint32_t g10(StructS *S, StructS2 *S2, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z3g10
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// PATH-LABEL: define{{.*}} i32 @_Z3g10
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_S_f32]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_S2_f32_2:!.*]]
  S->f32 = 1;
  S2->f32_2 = 4;
  return S->f32;
}

uint32_t g11(StructC *C, StructD *D, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z3g11
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// PATH-LABEL: define{{.*}} i32 @_Z3g11
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_C_b_a_f32:!.*]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_D_b_a_f32:!.*]]
  C->b.a.f32 = 1;
  D->b.a.f32 = 4;
  return C->b.a.f32;
}

uint32_t g12(StructC *C, StructD *D, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z3g12
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i32]]
// TODO: differentiate the two accesses.
// PATH-LABEL: define{{.*}} i32 @_Z3g12
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TAG_B_a_f32]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TAG_B_a_f32]]
  StructB *b1 = &(C->b);
  StructB *b2 = &(D->b);
  // b1, b2 have different context.
  b1->a.f32 = 1;
  b2->a.f32 = 4;
  return b1->a.f32;
}

uint32_t g13(StructM1 *M, StructS *S) {
  // CHECK-LABEL: define{{.*}} i32 @_Z3g13
  // CHECK: store i16 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i16]]
  // CHECK: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i16]]
  // PATH-LABEL: define{{.*}} i32 @_Z3g13
  // PATH: store i16 1, ptr %{{.*}}, align 4, !tbaa [[TAG_S_f16]]
  // PATH: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TAG_M1_f16_2:!.*]]
  S->f16 = 1;
  M->f16_2 = 4;
  return S->f16;
}

uint32_t g14(StructM2 *M, StructS *S) {
  // CHECK-LABEL: define{{.*}} i32 @_Z3g14
  // CHECK: store i16 1, ptr %{{.*}}, align 4, !tbaa [[TAG_i16]]
  // CHECK: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TAG_i16]]
  // PATH-LABEL: define{{.*}} i32 @_Z3g14
  // PATH: store i16 1, ptr %{{.*}}, align 4, !tbaa [[TAG_S_f16]]
  // PATH: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TAG_M2_f16_2:!.*]]
  S->f16 = 1;
  M->f16_2 = 4;
  return S->f16;
}

// CHECK: [[TAG_i32]] = !{[[TYPE_i32:!.*]], [[TYPE_i32]], i64 0}
// CHECK: [[TYPE_i32]] = !{!"int", [[TYPE_char:!.*]],
// CHECK: [[TYPE_char:!.*]] = !{!"omnipotent char", [[TAG_cxx_tbaa:!.*]],
// CHECK: [[TAG_cxx_tbaa]] = !{!"Simple C++ TBAA"}
// CHECK: [[TAG_i16]] = !{[[TYPE_i16:!.*]], [[TYPE_i16]], i64 0}
// CHECK: [[TYPE_i16]] = !{!"short", [[TYPE_char]],

// OLD-PATH: [[TAG_i32]] = !{[[TYPE_INT:!.*]], [[TYPE_INT]], i64 0}
// OLD-PATH: [[TYPE_INT]] = !{!"int", [[TYPE_CHAR:!.*]]
// OLD-PATH: [[TYPE_CHAR:!.*]] = !{!"omnipotent char", !
// OLD-PATH: [[TAG_A_f32]] = !{[[TYPE_A:!.*]], [[TYPE_INT]], i64 4}
// OLD-PATH: [[TYPE_A]] = !{!"_ZTS7StructA", [[TYPE_SHORT:!.*]], i64 0, [[TYPE_INT]], i64 4, [[TYPE_SHORT]], i64 8, [[TYPE_INT]], i64 12}
// OLD-PATH: [[TYPE_SHORT:!.*]] = !{!"short", [[TYPE_CHAR]]
// OLD-PATH: [[TAG_A_f16]] = !{[[TYPE_A]], [[TYPE_SHORT]], i64 0}
// OLD-PATH: [[TAG_B_a_f32]] = !{[[TYPE_B:!.*]], [[TYPE_INT]], i64 8}
// OLD-PATH: [[TYPE_B]] = !{!"_ZTS7StructB", [[TYPE_SHORT]], i64 0, [[TYPE_A]], i64 4, [[TYPE_INT]], i64 20}
// OLD-PATH: [[TAG_B_a_f16]] = !{[[TYPE_B]], [[TYPE_SHORT]], i64 4}
// OLD-PATH: [[TAG_B_f32]] = !{[[TYPE_B]], [[TYPE_INT]], i64 20}
// OLD-PATH: [[TAG_B_a_f32_2]] = !{[[TYPE_B]], [[TYPE_INT]], i64 16}
// OLD-PATH: [[TAG_S_f32]] = !{[[TYPE_S:!.*]], [[TYPE_INT]], i64 4}
// OLD-PATH: [[TYPE_S]] = !{!"_ZTS7StructS", [[TYPE_SHORT]], i64 0, [[TYPE_INT]], i64 4}
// OLD-PATH: [[TAG_S_f16]] = !{[[TYPE_S]], [[TYPE_SHORT]], i64 0}
// OLD-PATH: [[TAG_S2_f32_2]] = !{[[TYPE_S2:!.*]], [[TYPE_INT]], i64 12}
// OLD-PATH: [[TYPE_S2]] = !{!"_ZTS8StructS2", [[TYPE_S]], i64 0, [[TYPE_SHORT]], i64 8, [[TYPE_INT]], i64 12}
// OLD-PATH: [[TAG_C_b_a_f32]] = !{[[TYPE_C:!.*]], [[TYPE_INT]], i64 12}
// OLD-PATH: [[TYPE_C]] = !{!"_ZTS7StructC", [[TYPE_SHORT]], i64 0, [[TYPE_B]], i64 4, [[TYPE_INT]], i64 28}
// OLD-PATH: [[TAG_D_b_a_f32]] = !{[[TYPE_D:!.*]], [[TYPE_INT]], i64 12}
// OLD-PATH: [[TYPE_D]] = !{!"_ZTS7StructD", [[TYPE_SHORT]], i64 0, [[TYPE_B]], i64 4, [[TYPE_INT]], i64 28, [[TYPE_CHAR]], i64 32}
// OLD-PATH: [[TAG_M1_f16_2]] = !{[[TYPE_M1:!.*]], [[TYPE_SHORT]], i64 12}
// OLD-PATH: [[TYPE_M1]] = !{!"_ZTS8StructM1", [[TYPE_S]], i64 0, [[TYPE_T:!.*]], i64 8, [[TYPE_SHORT]], i64 12}
// OLD_PATH: [[TYPE_T]] = !{!"_ZTS7StructT", [[TYPE_INT]], i64 0}
// OLD-PATH: [[TAG_M2_f16_2]] = !{[[TYPE_M2:!.*]], [[TYPE_SHORT]], i64 20}
// OLD-PATH: [[TYPE_M2]] = !{!"_ZTS8StructM2", [[TYPE_DYN:!.*]], i64 0, [[TYPE_S]], i64 12, [[TYPE_SHORT]], i64 20}
// OLD_PATH: [[TYPE_DYN]] = !{!"_ZTS9StructDyn", [[TYPE_INT]], i64 8}

// NEW-PATH: [[TAG_i32]] = !{[[TYPE_INT:!.*]], [[TYPE_INT:!.*]], i64 0, i64 4}
// NEW-PATH: [[TYPE_INT]] = !{[[TYPE_CHAR:!.*]], i64 4, !"int"}
// NEW-PATH: [[TYPE_CHAR:!.*]] = !{!{{.*}}, i64 1, !"omnipotent char"}
// NEW-PATH: [[TAG_A_f32]] = !{[[TYPE_A:!.*]], [[TYPE_INT]], i64 4, i64 4}
// NEW-PATH: [[TYPE_A]] = !{[[TYPE_CHAR]], i64 16, !"_ZTS7StructA", [[TYPE_SHORT:!.*]], i64 0, i64 2, [[TYPE_INT]], i64 4, i64 4, [[TYPE_SHORT]], i64 8, i64 2, [[TYPE_INT]], i64 12, i64 4}
// NEW-PATH: [[TYPE_SHORT:!.*]] = !{[[TYPE_CHAR]], i64 2, !"short"}
// NEW-PATH: [[TAG_A_f16]] = !{[[TYPE_A]], [[TYPE_SHORT]], i64 0, i64 2}
// NEW-PATH: [[TAG_B_a_f32]] = !{[[TYPE_B:!.*]], [[TYPE_INT]], i64 8, i64 4}
// NEW-PATH: [[TYPE_B]] = !{[[TYPE_CHAR]], i64 24, !"_ZTS7StructB", [[TYPE_SHORT]], i64 0, i64 2, [[TYPE_A]], i64 4, i64 16, [[TYPE_INT]], i64 20, i64 4}
// NEW-PATH: [[TAG_B_a_f16]] = !{[[TYPE_B]], [[TYPE_SHORT]], i64 4, i64 2}
// NEW-PATH: [[TAG_B_f32]] = !{[[TYPE_B]], [[TYPE_INT]], i64 20, i64 4}
// NEW-PATH: [[TAG_B_a_f32_2]] = !{[[TYPE_B]], [[TYPE_INT]], i64 16, i64 4}
// NEW-PATH: [[TAG_S_f32]] = !{[[TYPE_S:!.*]], [[TYPE_INT]], i64 4, i64 4}
// NEW-PATH: [[TYPE_S]] = !{[[TYPE_CHAR]], i64 8, !"_ZTS7StructS", [[TYPE_SHORT]], i64 0, i64 2, [[TYPE_INT]], i64 4, i64 4}
// NEW-PATH: [[TAG_S_f16]] = !{[[TYPE_S]], [[TYPE_SHORT]], i64 0, i64 2}
// NEW-PATH: [[TAG_S2_f32_2]] = !{[[TYPE_S2:!.*]], [[TYPE_INT]], i64 12, i64 4}
// NEW-PATH: [[TYPE_S2]] = !{[[TYPE_CHAR]], i64 16, !"_ZTS8StructS2", [[TYPE_S]], i64 0, i64 8, [[TYPE_SHORT]], i64 8, i64 2, [[TYPE_INT]], i64 12, i64 4}
// NEW-PATH: [[TAG_C_b_a_f32]] = !{[[TYPE_C:!.*]], [[TYPE_INT]], i64 12, i64 4}
// NEW-PATH: [[TYPE_C]] = !{[[TYPE_CHAR]], i64 32, !"_ZTS7StructC", [[TYPE_SHORT]], i64 0, i64 2, [[TYPE_B]], i64 4, i64 24, [[TYPE_INT]], i64 28, i64 4}
// NEW-PATH: [[TAG_D_b_a_f32]] = !{[[TYPE_D:!.*]], [[TYPE_INT]], i64 12, i64 4}
// NEW-PATH: [[TYPE_D]] = !{[[TYPE_CHAR]], i64 36, !"_ZTS7StructD", [[TYPE_SHORT]], i64 0, i64 2, [[TYPE_B]], i64 4, i64 24, [[TYPE_INT]], i64 28, i64 4, [[TYPE_CHAR]], i64 32, i64 1}
// NEW-PATH: [[TAG_M1_f16_2]] = !{[[TYPE_M1:!.*]], [[TYPE_SHORT]], i64 12, i64 2}
// NEW-PATH: [[TYPE_M1]] = !{[[TYPE_CHAR]], i64 16, !"_ZTS8StructM1", [[TYPE_S]], i64 0, i64 8, [[TYPE_T:!.*]], i64 8, i64 4, [[TYPE_SHORT]], i64 12, i64 2}
// NEW_PATH: [[TYPE_T]] = !{[[TYPE_CHAR]], i64 4, !"_ZTS7StructT", [[TYPE_INT]], i64 0, i64 4}
// NEW-PATH: [[TAG_M2_f16_2]] = !{[[TYPE_M2:!.*]], [[TYPE_SHORT]], i64 20, i64 2}
// NEW-PATH: [[TYPE_M2]] = !{[[TYPE_CHAR]], i64 24, !"_ZTS8StructM2", [[TYPE_DYN:!.*]], i64 0, i64 12, [[TYPE_S]], i64 12, i64 8, [[TYPE_SHORT]], i64 20, i64 2}
// NEW_PATH: [[TYPE_DYN]] = !{[[TYPE_CHAR]], i64 12, !"_ZTS9StructDyn", [[TYPE_INT]], i64 8, i64 4}
