/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "uosprocheader.h"

gint uos_procheader_get_one_field		(gchar		*buf,
                     size_t		 len,
                     FILE		*fp,
                                         UosHeaderEntry	 hentry[]){
     return procheader_get_one_field		(buf,len,fp,hentry);
}

gchar *uos_procheader_get_unfolded_line	(gchar		*buf,
                     size_t		 len,
                     FILE		*fp){
    return procheader_get_unfolded_line	(buf,len,fp);
}

GSList *uos_procheader_get_header_list_from_file	(const gchar	*file){
    return procheader_get_header_list_from_file	(file);
}

GSList *uos_procheader_get_header_list		(FILE		*fp){
    return procheader_get_header_list		(fp);
}

GSList *uos_procheader_get_header_list_from_msginfo	(UosMsgInfo	*msginfo){
    return procheader_get_header_list_from_msginfo	(msginfo);
}

GSList *uos_procheader_add_header_list		(GSList		*hlist,
                         const gchar	*header_name,
                         const gchar	*body){
    return procheader_add_header_list		(hlist,header_name,body);
}

GSList *uos_procheader_copy_header_list		(GSList		*hlist){
    return procheader_copy_header_list		(hlist);
}

GSList *uos_procheader_merge_header_list		(GSList		*hlist1,
                         GSList		*hlist2){
    return procheader_merge_header_list		(hlist1,hlist2);
}

GSList *uos_procheader_merge_header_list_dup	(GSList		*hlist1,
                         GSList		*hlist2){
    return procheader_merge_header_list_dup		(hlist1,hlist2);
}

gint uos_procheader_find_header_list		(GSList		*hlist,
                         const gchar	*header_name){
    return procheader_find_header_list		(hlist,header_name);
}

void uos_procheader_header_list_destroy		(GSList		*hlist){
    procheader_header_list_destroy		(hlist);
}

GPtrArray *uos_procheader_get_header_array		(FILE		*fp,
                         const gchar	*encoding){
    return procheader_get_header_array		(fp,encoding);
}

GPtrArray *uos_procheader_get_header_array_asis	(FILE		*fp,
                         const gchar	*encoding){
    return procheader_get_header_array_asis		(fp,encoding);
}

GPtrArray *uos_procheader_get_header_array_for_display
                        (FILE		*fp,
                         const gchar	*encoding){
    return procheader_get_header_array_for_display		(fp,encoding);
}

void uos_procheader_header_array_destroy		(GPtrArray	*harray){
    procheader_header_array_destroy		(harray);
}


void uos_procheader_header_free			(UosHeader		*header){
    procheader_header_free			(header);
}


void uos_procheader_get_header_fields	(FILE		*fp,
                     UosHeaderEntry	 hentry[]){
    procheader_get_header_fields	(fp,hentry);
}

UosMsgInfo *uos_procheader_parse_file		(const gchar	*file,
                     UosMsgFlags	 flags,
                     gboolean	 full){
    return procheader_parse_file		(file,flags,full);
}

UosMsgInfo *uos_procheader_parse_str		(const gchar	*str,
                     UosMsgFlags	 flags,
                     gboolean	 full){
    return procheader_parse_str		(str,flags,full);
}

UosMsgInfo *uos_procheader_parse_stream	(FILE		*fp,
                     UosMsgFlags	 flags,
                     gboolean	 full){
    return procheader_parse_stream		(fp,flags,full);
}


gchar *uos_procheader_get_fromname		(const gchar	*str){
    return procheader_get_fromname		(str);
}


gchar *uos_procheader_get_toname		(const gchar	*str){
    return procheader_get_toname		(str);
}


stime_t uos_procheader_date_parse		(gchar		*dest,
                     const gchar	*src,
                     gint		 len){
    return procheader_date_parse		(dest,src,len);
}

void uos_procheader_date_get_localtime	(gchar		*dest,
                     gint		 len,
                     const stime_t	 timer){
    procheader_date_get_localtime	(dest,len,timer);
}

