/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSBASE64_H__
#define __UOSBASE64_H__

#include "libsylph/base64.h"

typedef Base64Decoder UosBase64Decoder;

void uos_base64_encode	(gchar		*out,
			 const guchar	*in,
			 gint		 inlen);
gint uos_base64_decode	(guchar		*out,
			 const gchar	*in,
			 gint		 inlen);

UosBase64Decoder *uos_base64_decoder_new	(void);
void	       uos_base64_decoder_free	(UosBase64Decoder	*decoder);
gint	       uos_base64_decoder_decode	(UosBase64Decoder	*decoder,
					 const gchar	*in,
					 guchar		*out);

#endif /* __UOSBASE64_H__ */
