#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
#
# this script is used by auto-documentation scripts
# to compute the relative path from top directory
# to the current directory.
#
# this is now no more usefull since the $(subdir)
# in the Makefile defines this !
#
if test $# -ne 1; then
    echo "$0: usage: $0 $top_builddir" 1>&2
    exit 1
fi
# top_srcdir = ../..
# pwd = /disk/pierre/dvt/rheolef/doc/refman
# => dir_prefix = doc/refman/
# 
# top_srcdir = .
# pwd = /disk/pierre/dvt/rheolef
# => dir_prefix = 
# 
top_srcdir=$1
if test "$top_srcdir" = "."; then
    exit 0
fi
# top_srcdir=../../.. ==> level=3
level=`echo $top_srcdir | sed -e 's,/, ,g' | awk '{print NF }'`
# echo level $level
pwd=`pwd`
echo `pwd` | sed -e 's,/, ,g' | awk -v level=$level '
 { 
    for (i = NF-level+1; i <= NF; i++) {
	printf ("%s", $i);
	if (i != NF) printf ("/");
    }
    printf ("/\n");
 }'

