% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apg_lookup.R
\name{apg_lookup}
\alias{apg_lookup}
\title{Lookup in the APGIII taxonomy and replace family names}
\usage{
apg_lookup(taxa, rank = "family")
}
\arguments{
\item{taxa}{(character) Taxonomic name to lookup a synonym for in APGIII taxonomy.}

\item{rank}{(character) Taxonomic rank to lookup a synonym for. One of family or order.}
}
\value{
A APGIII family or order name, or the original name if no match.
}
\description{
Lookup in the APGIII taxonomy and replace family names
}
\details{
Internally in this function, we use the datasets \code{\link{apg_families}}
and \code{\link{apg_orders}} - see their descriptions for the data in them.
The functions \code{\link{apgOrders}} \code{\link{apgFamilies}} are for scraping
current content from the \url{http://www.mobot.org/MOBOT/research/APweb/} website.

BEWARE: The datasets used in this function are (I think) from Version 12 of the data
on \url{http://www.mobot.org/MOBOT/research/APweb/} - I'll update data asap.
}
\examples{
# New name found
apg_lookup(taxa = "Hyacinthaceae", rank = "family")
apg_lookup(taxa = "Poaceae", rank = "family")

# Name not found
apg_lookup(taxa = "Asteraceae", rank = "family")
}
