% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attr_access.R
\name{get_leaves_branches_attr}
\alias{get_leaves_branches_attr}
\title{Get an attribute of the branches of a dendrogram's leaves}
\usage{
get_leaves_branches_attr(dend, attr = c("col", "lwd", "lty"), ...)
}
\arguments{
\item{dend}{a dendrogram object}

\item{attr}{character, the attr to get. Can be either "col", "lwd", or "lty".}

\item{...}{not used}
}
\value{
A vector with the dendrogram's leaves nodePar attribute
}
\description{
This is helpful to get the attributes of branches of the leaves.
For example, after we use \link{color_branches}, to get the colors
of the labels to match (since getting the colors of branches to match
those of the labels can be tricky).
This is based on \link{get_leaves_edgePar}.
}
\examples{
# define dendrogram object to play with:
hc <- hclust(dist(USArrests[1:5,]), "ave")
dend <- as.dendrogram(hc)

dend <- dend \%>\% 
         color_branches(k = 3) \%>\%
         set("branches_lwd", c(2,1,2)) \%>\%
         set("branches_lty", c(1,2,1))
         
plot(dend)

get_leaves_branches_attr(dend, "col")
get_leaves_branches_attr(dend, "lwd")
get_leaves_branches_attr(dend, "lty")

labels_colors(dend)  <- get_leaves_branches_attr(dend, "col")
plot(dend)


}
\seealso{
\link{get_nodes_attr}, \link{assign_values_to_leaves_nodePar}, \link{labels_colors}
\link{get_leaves_nodePar}, \link{get_leaves_edgePar}
}
