/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "build_config.h"
#include "compiler.h"

/* ==================== RUNTIME_RM ==================== */
#ifdef RUNTIME_RM

CODE16;

#include "in.h"

static unsigned short
swab16(unsigned short x)
{
	return ((x & 0x00ff) << 8)
	     | ((x & 0xff00) >> 8);
}

static unsigned long
swab32(unsigned long x)
{
	return ((x & 0x000000ff) << 24)
	     | ((x & 0x0000ff00) <<  8)
	     | ((x & 0x00ff0000) >>  8)
	     | ((x & 0xff000000) >> 24);
}

unsigned short
htons(unsigned short x)
{
	return swab16(x);
}

unsigned short
ntohs(unsigned short x)
{
	return swab16(x);
}

unsigned long
htonl(unsigned long x)
{
	return swab32(x);
}

unsigned long
ntohl(unsigned long x)
{
	return swab32(x);
}

#endif /* RUNTIME_RM */
