/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __XML_H_INCLUDED
#define __XML_H_INCLUDED

struct xml_attr {
	struct xml_attr *prev;
	struct xml_attr *next;

	char *tag;
	char *val;
};

struct xml {
	struct xml *prev;
	struct xml *next;

	enum {
		XML_START,
		XML_END,
		XML_START_END,
		XML_TEXT
	} type;
	union {
		struct {
			char *string;
			struct xml_attr *attr_first;
			struct xml_attr *attr_last;
			struct xml *child_first;
			struct xml *child_last;
		} start;
		struct {
			char *string;
		} end;
		struct {
			char *string;
		} text;
	};
};

extern struct xml *
xml_parse(FILE *fp);

extern void
xml_write(FILE *fp, struct xml *xml);

extern void
xml_append(struct xml *parent, struct xml *child);

extern struct xml *
xml_alloc(const char *tag);
extern struct xml *
xml_alloc_text(const char *text);

extern void
xml_free(struct xml *p);

extern void
xml_attr_set(struct xml *e, const char *tag, const char *val);

extern const char *
xml_attr_lookup(struct xml *e, const char *tag);

#endif /* __XML_H_INCLUDED */
