-- $Id$

-- test concurrent signal assignment statements

-- Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.

entity test_bench is
end entity test_bench;

architecture test_bench_impl of test_bench is
	signal t1 : boolean;
	signal t2 : boolean;
	signal t3 : boolean;
begin

	t1 <= 	true after 5 ms		when t2 and t3 else
		false after 5 ms 	when (not t2) and (not t3);

	p : process
	begin
		t2 <= true; t3 <= true;
		wait for 10 ms;
		assert t1 report "t1 not true" severity failure;

		t2 <= false;
		wait for 10 ms;
		assert t1 report "t1 not true" severity failure;

		t3 <= false;
		wait for 10 ms;
		assert not t1 report "t1 true" severity failure;

		assert false report "simulation finished" severity note;
		wait;
	end process;
end;
