/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/SubtypeIndication.hpp"
#include <cassert>
#include "frontend/misc/Symbol.hpp"
#include "frontend/ast/UnconstrainedArrayType.hpp"

namespace ast {

SubtypeIndication::SubtypeIndication(
	Name *typeMark,
	Location loc
	) : 	TypeDeclaration(NULL, loc, BASE_TYPE_UNSET),
		typeName(typeMark),
		constraint(NULL),
		indexConstraint(NULL),
		resolutionFunction(NULL),
		declaration(NULL) {

	if (typeMark && typeMark->candidates.size() == 1) {
		Symbol *sym = typeMark->candidates.front();
		this->declaration = dynamic_cast<const TypeDeclaration*>(
							&sym->declaration);
		assert(this->declaration);
		this->baseType = this->declaration->baseType;
	}
}

SubtypeIndication::SubtypeIndication(
	const TypeDeclaration *byType,
	Location loc
) :		TypeDeclaration(NULL, loc, byType->baseType),
		typeName(NULL),
		constraint(NULL),
		indexConstraint(NULL),
		resolutionFunction(NULL),
		declaration(byType)
{
}

std::string *
SubtypeIndication::getResolver(void) const
{
	if (this->resolutionFunction == NULL) {
		const SubtypeIndication *parent = 
			dynamic_cast<const SubtypeIndication*>(
							this->declaration);
		if (parent == NULL) {
			/* check for array types */
			const UnconstrainedArrayType *ua =
				dynamic_cast<const UnconstrainedArrayType*>(
					this->declaration);
			if (ua == NULL) {
				return NULL;
			}
			const SubtypeIndication *si = 
				dynamic_cast<const SubtypeIndication *>(
					ua->elementType);
			if (si != NULL) {
				return si->getResolver();
			}

			/* can records be resolved? */
			return NULL;
		}

		return parent->getResolver();
	}

	if (this->resolutionFunction->candidates.size() != 1) {
		assert(false);
		return NULL;
	}

	return new std::string(this->resolutionFunction->getName());
}

}; /* namespace ast */
