/*
 * Decompiled with CFR 0.152.
 */
package gnu.bioinformatics.jaligner.util;

import gnu.bioinformatics.jaligner.exceptions.ParserException;
import gnu.bioinformatics.jaligner.formats.FASTA;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Parser {
    public static FASTA parseFASTA(String sequence) throws ParserException {
        if (sequence == null) {
            throw new ParserException("Null FASTA");
        }
        if ((sequence = sequence.trim()).length() == 0) {
            throw new ParserException("Empty FASTA");
        }
        if (!sequence.startsWith(">")) {
            throw new ParserException("Does not start with \">\"");
        }
        int index = sequence.indexOf("\n");
        if (index == -1) {
            throw new ParserException("No sequence");
        }
        String first = sequence.substring(1, index);
        sequence = sequence.substring(index).toUpperCase();
        index = 0;
        int i = 0;
        while (i < first.length() && first.charAt(i) != ' ' && first.charAt(i) != '\t') {
            ++i;
            ++index;
        }
        String sequenceName = first.substring(0, index);
        String sequenceDescription = index + 1 > first.length() ? "" : first.substring(index + 1);
        char[] buffer = Parser.prepareSequence(sequence.toUpperCase());
        FASTA fasta = new FASTA();
        fasta.setDescription(sequenceDescription);
        fasta.setName(sequenceName);
        fasta.setSequence(buffer);
        return fasta;
    }

    public static FASTA loadFASTA(InputStream is) throws IOException, ParserException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = reader.readLine();
        if (!line.startsWith(">")) {
            throw new ParserException("No \">\"");
        }
        line = line.substring(1).trim();
        int index = 0;
        int i = 0;
        while (i < line.length() && line.charAt(i) != ' ' && line.charAt(i) != '\t') {
            ++i;
            ++index;
        }
        String sequenceName = line.substring(0, index);
        String sequenceDescription = index + 1 > line.length() ? "" : line.substring(index + 1);
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
        }
        reader.close();
        FASTA fasta = new FASTA();
        fasta.setDescription(sequenceDescription);
        fasta.setName(sequenceName);
        fasta.setSequence(Parser.prepareSequence(buffer.toString().toUpperCase()));
        return fasta;
    }

    public static FASTA loadFASTA(File file) throws FileNotFoundException, IOException, ParserException {
        return Parser.loadFASTA(new FileInputStream(file));
    }

    public static FASTA loadFASTA(String filename) throws Exception {
        return Parser.loadFASTA(new FileInputStream(filename));
    }

    public static char[] prepareSequence(String sequence) throws ParserException {
        return Parser.prepareSequence(sequence.toCharArray());
    }

    public static char[] prepareSequence(char[] sequence) throws ParserException {
        char[] buffer1 = new char[sequence.length];
        int length = 0;
        int i = 0;
        int n = sequence.length;
        while (i < n) {
            switch (sequence[i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '*': 
                case '-': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    buffer1[length++] = sequence[i];
                    break;
                }
                default: {
                    throw new ParserException("Invalid sequence character: " + sequence[i]);
                }
            }
            ++i;
        }
        char[] buffer2 = new char[length];
        int i2 = 0;
        while (i2 < length) {
            buffer2[i2] = buffer1[i2];
            ++i2;
        }
        return buffer2;
    }
}

