/*
 * Decompiled with CFR 0.152.
 */
package jalview.math;

import jalview.util.Format;
import java.io.PrintStream;

public class Matrix {
    public double[][] value;
    public int rows;
    public int cols;
    public double[] d;
    public double[] e;

    public Matrix(double[][] value, int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.value = value;
    }

    public Matrix transpose() {
        double[][] out = new double[this.cols][this.rows];
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                out[i][j] = this.value[j][i];
            }
        }
        return new Matrix(out, this.cols, this.rows);
    }

    public void print(PrintStream ps) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                Format.print(ps, "%8.2f", this.value[i][j]);
            }
            ps.println();
        }
    }

    public Matrix preMultiply(Matrix in) {
        double[][] tmp = new double[in.rows][this.cols];
        for (int i = 0; i < in.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                tmp[i][j] = 0.0;
                for (int k = 0; k < in.cols; ++k) {
                    double[] dArray = tmp[i];
                    int n = j;
                    dArray[n] = dArray[n] + in.value[i][k] * this.value[k][j];
                }
            }
        }
        return new Matrix(tmp, in.rows, this.cols);
    }

    public double[] vectorPostMultiply(double[] in) {
        double[] out = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = 0.0;
            for (int k = 0; k < in.length; ++k) {
                int n = i;
                out[n] = out[n] + this.value[i][k] * in[k];
            }
        }
        return out;
    }

    public Matrix postMultiply(Matrix in) {
        double[][] out = new double[this.rows][in.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < in.cols; ++j) {
                out[i][j] = 0.0;
                for (int k = 0; k < this.rows; ++k) {
                    out[i][j] = out[i][j] + this.value[i][k] * in.value[k][j];
                }
            }
        }
        return new Matrix(out, this.cols, in.rows);
    }

    public Matrix copy() {
        double[][] newmat = new double[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                newmat[i][j] = this.value[i][j];
            }
        }
        return new Matrix(newmat, this.rows, this.cols);
    }

    public void tred() {
        int j;
        double g;
        int k;
        int l;
        int i;
        int n = this.rows;
        this.d = new double[this.rows];
        this.e = new double[this.rows];
        for (i = n; i >= 2; --i) {
            l = i - 1;
            double h = 0.0;
            double scale = 0.0;
            if (l > 1) {
                for (k = 1; k <= l; ++k) {
                    scale += Math.abs(this.value[i - 1][k - 1]);
                }
                if (scale == 0.0) {
                    this.e[i - 1] = this.value[i - 1][l - 1];
                } else {
                    for (k = 1; k <= l; ++k) {
                        double[] dArray = this.value[i - 1];
                        int n2 = k - 1;
                        dArray[n2] = dArray[n2] / scale;
                        h += this.value[i - 1][k - 1] * this.value[i - 1][k - 1];
                    }
                    double f = this.value[i - 1][l - 1];
                    g = f > 0.0 ? -1.0 * Math.sqrt(h) : Math.sqrt(h);
                    this.e[i - 1] = scale * g;
                    h -= f * g;
                    this.value[i - 1][l - 1] = f - g;
                    f = 0.0;
                    for (j = 1; j <= l; ++j) {
                        this.value[j - 1][i - 1] = this.value[i - 1][j - 1] / h;
                        g = 0.0;
                        for (k = 1; k <= j; ++k) {
                            g += this.value[j - 1][k - 1] * this.value[i - 1][k - 1];
                        }
                        for (k = j + 1; k <= l; ++k) {
                            g += this.value[k - 1][j - 1] * this.value[i - 1][k - 1];
                        }
                        this.e[j - 1] = g / h;
                        f += this.e[j - 1] * this.value[i - 1][j - 1];
                    }
                    double hh = f / (h + h);
                    for (j = 1; j <= l; ++j) {
                        f = this.value[i - 1][j - 1];
                        this.e[j - 1] = g = this.e[j - 1] - hh * f;
                        for (k = 1; k <= j; ++k) {
                            double[] dArray = this.value[j - 1];
                            int n3 = k - 1;
                            dArray[n3] = dArray[n3] - (f * this.e[k - 1] + g * this.value[i - 1][k - 1]);
                        }
                    }
                }
            } else {
                this.e[i - 1] = this.value[i - 1][l - 1];
            }
            this.d[i - 1] = h;
        }
        this.d[0] = 0.0;
        this.e[0] = 0.0;
        for (i = 1; i <= n; ++i) {
            l = i - 1;
            if (this.d[i - 1] != 0.0) {
                for (j = 1; j <= l; ++j) {
                    g = 0.0;
                    for (k = 1; k <= l; ++k) {
                        g += this.value[i - 1][k - 1] * this.value[k - 1][j - 1];
                    }
                    for (k = 1; k <= l; ++k) {
                        double[] dArray = this.value[k - 1];
                        int n4 = j - 1;
                        dArray[n4] = dArray[n4] - g * this.value[k - 1][i - 1];
                    }
                }
            }
            this.d[i - 1] = this.value[i - 1][i - 1];
            this.value[i - 1][i - 1] = 1.0;
            for (j = 1; j <= l; ++j) {
                this.value[j - 1][i - 1] = 0.0;
                this.value[i - 1][j - 1] = 0.0;
            }
        }
    }

    public void tqli() {
        int i;
        int n = this.rows;
        for (i = 2; i <= n; ++i) {
            this.e[i - 2] = this.e[i - 1];
        }
        this.e[n - 1] = 0.0;
        for (int l = 1; l <= n; ++l) {
            int m;
            int iter = 0;
            do {
                double c;
                for (m = l; m <= n - 1; ++m) {
                    double dd = Math.abs(this.d[m - 1]) + Math.abs(this.d[m]);
                    if (Math.abs(this.e[m - 1]) + dd == dd) break;
                }
                if (m == l) continue;
                if (++iter == 30) {
                    System.err.print("Too many iterations in tqli");
                    System.exit(0);
                }
                double g = (this.d[l] - this.d[l - 1]) / (2.0 * this.e[l - 1]);
                double r = Math.sqrt(g * g + 1.0);
                g = this.d[m - 1] - this.d[l - 1] + this.e[l - 1] / (g + this.sign(r, g));
                double s = c = 1.0;
                double p = 0.0;
                for (i = m - 1; i >= l; --i) {
                    double f = s * this.e[i - 1];
                    double b = c * this.e[i - 1];
                    if (Math.abs(f) >= Math.abs(g)) {
                        c = g / f;
                        r = Math.sqrt(c * c + 1.0);
                        this.e[i] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = Math.sqrt(s * s + 1.0);
                        this.e[i] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = this.d[i] - p;
                    r = (this.d[i - 1] - g) * s + 2.0 * c * b;
                    p = s * r;
                    this.d[i] = g + p;
                    g = c * r - b;
                    for (int k = 1; k <= n; ++k) {
                        f = this.value[k - 1][i];
                        this.value[k - 1][i] = s * this.value[k - 1][i - 1] + c * f;
                        this.value[k - 1][i - 1] = c * this.value[k - 1][i - 1] - s * f;
                    }
                }
                this.d[l - 1] = this.d[l - 1] - p;
                this.e[l - 1] = g;
                this.e[m - 1] = 0.0;
            } while (m != l);
        }
    }

    public void tred2() {
        int j;
        double g;
        int k;
        int l;
        int i;
        int n = this.rows;
        this.d = new double[this.rows];
        this.e = new double[this.rows];
        for (i = n - 1; i >= 1; --i) {
            l = i - 1;
            double h = 0.0;
            double scale = 0.0;
            if (l > 0) {
                for (k = 0; k < l; ++k) {
                    scale += Math.abs(this.value[i][k]);
                }
                if (scale == 0.0) {
                    this.e[i] = this.value[i][l];
                } else {
                    for (k = 0; k < l; ++k) {
                        double[] dArray = this.value[i];
                        int n2 = k;
                        dArray[n2] = dArray[n2] / scale;
                        h += this.value[i][k] * this.value[i][k];
                    }
                    double f = this.value[i][l];
                    g = f > 0.0 ? -1.0 * Math.sqrt(h) : Math.sqrt(h);
                    this.e[i] = scale * g;
                    h -= f * g;
                    this.value[i][l] = f - g;
                    f = 0.0;
                    for (j = 0; j < l; ++j) {
                        this.value[j][i] = this.value[i][j] / h;
                        g = 0.0;
                        for (k = 0; k < j; ++k) {
                            g += this.value[j][k] * this.value[i][k];
                        }
                        for (k = j; k < l; ++k) {
                            g += this.value[k][j] * this.value[i][k];
                        }
                        this.e[j] = g / h;
                        f += this.e[j] * this.value[i][j];
                    }
                    double hh = f / (h + h);
                    for (j = 0; j < l; ++j) {
                        f = this.value[i][j];
                        this.e[j] = g = this.e[j] - hh * f;
                        for (k = 0; k < j; ++k) {
                            double[] dArray = this.value[j];
                            int n3 = k;
                            dArray[n3] = dArray[n3] - (f * this.e[k] + g * this.value[i][k]);
                        }
                    }
                }
            } else {
                this.e[i] = this.value[i][l];
            }
            this.d[i] = h;
        }
        this.d[0] = 0.0;
        this.e[0] = 0.0;
        for (i = 0; i < n; ++i) {
            l = i - 1;
            if (this.d[i] != 0.0) {
                for (j = 0; j < l; ++j) {
                    g = 0.0;
                    for (k = 0; k < l; ++k) {
                        g += this.value[i][k] * this.value[k][j];
                    }
                    for (k = 0; k < l; ++k) {
                        double[] dArray = this.value[k];
                        int n4 = j;
                        dArray[n4] = dArray[n4] - g * this.value[k][i];
                    }
                }
            }
            this.d[i] = this.value[i][i];
            this.value[i][i] = 1.0;
            for (j = 0; j < l; ++j) {
                this.value[j][i] = 0.0;
                this.value[i][j] = 0.0;
            }
        }
    }

    public void tqli2() {
        int i;
        int n = this.rows;
        for (i = 2; i <= n; ++i) {
            this.e[i - 2] = this.e[i - 1];
        }
        this.e[n - 1] = 0.0;
        for (int l = 1; l <= n; ++l) {
            int m;
            int iter = 0;
            do {
                double c;
                for (m = l; m <= n - 1; ++m) {
                    double dd = Math.abs(this.d[m - 1]) + Math.abs(this.d[m]);
                    if (Math.abs(this.e[m - 1]) + dd == dd) break;
                }
                if (m == l) continue;
                if (++iter == 30) {
                    System.err.print("Too many iterations in tqli");
                    System.exit(0);
                }
                double g = (this.d[l] - this.d[l - 1]) / (2.0 * this.e[l - 1]);
                double r = Math.sqrt(g * g + 1.0);
                g = this.d[m - 1] - this.d[l - 1] + this.e[l - 1] / (g + this.sign(r, g));
                double s = c = 1.0;
                double p = 0.0;
                for (i = m - 1; i >= l; --i) {
                    double f = s * this.e[i - 1];
                    double b = c * this.e[i - 1];
                    if (Math.abs(f) >= Math.abs(g)) {
                        c = g / f;
                        r = Math.sqrt(c * c + 1.0);
                        this.e[i] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = Math.sqrt(s * s + 1.0);
                        this.e[i] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = this.d[i] - p;
                    r = (this.d[i - 1] - g) * s + 2.0 * c * b;
                    p = s * r;
                    this.d[i] = g + p;
                    g = c * r - b;
                    for (int k = 1; k <= n; ++k) {
                        f = this.value[k - 1][i];
                        this.value[k - 1][i] = s * this.value[k - 1][i - 1] + c * f;
                        this.value[k - 1][i - 1] = c * this.value[k - 1][i - 1] - s * f;
                    }
                }
                this.d[l - 1] = this.d[l - 1] - p;
                this.e[l - 1] = g;
                this.e[m - 1] = 0.0;
            } while (m != l);
        }
    }

    public double sign(double a, double b) {
        if (b < 0.0) {
            return -Math.abs(a);
        }
        return Math.abs(a);
    }

    public double[] getColumn(int n) {
        double[] out = new double[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            out[i] = this.value[i][n];
        }
        return out;
    }

    public void printD(PrintStream ps) {
        for (int j = 0; j < this.rows; ++j) {
            Format.print(ps, "%15.4e", this.d[j]);
        }
    }

    public void printE(PrintStream ps) {
        for (int j = 0; j < this.rows; ++j) {
            Format.print(ps, "%15.4e", this.e[j]);
        }
    }

    public static void main(String[] args) {
        int n = Integer.parseInt(args[0]);
        double[][] in = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                in[i][j] = Math.random();
            }
        }
        Matrix origmat = new Matrix(in, n, n);
        Matrix trans = origmat.transpose();
        Matrix symm = trans.postMultiply(origmat);
        symm.tred();
        symm.tqli();
    }
}

