#!/bin/bash
#
# Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# This module defines basic utilities used in almost all scripts.

# Set environment
export LANG=C LC_ALL=C
export DEBIAN_FRONTEND="noninteractive"
export APT_OPTIONS='-y -o Dpkg::Options::="--force-confdef" \
  -o Dpkg::Options::="--force-confold" --force-yes --no-install-recommends \
  --allow-unauthenticated'

# Absolute path to config file.
# Do not read from/write to this file, call installer_get/installer_set instead.
CONF_FILE=/etc/deepin-installer.conf
EXPERIENCE_FILE=/etc/deepin/deepin-user-experience

# Print error message and exit
error() {
  local msg="$@"
  echo " "
  echo "!! Error: ${msg}" >&2
  echo " "
  exit 1
}

warn() {
  local msg="$@"
  echo "Warn: ${msg}" >&2
}

warn_exit() {
  local msg="$@"
  echo "Warn: ${msg}" >&2
  exit 0
}

# standard message
msg() {
  local msg="$@"
  echo "Info: ${msg}"
}

debug() {
  local msg="$@"
  echo "Debug: ${msg}"
}

# Get value in conf file. Section name is ignored.
# NOTE(xushaohua): Global variant or environment $CONF_FILE must not be empty.
installer_get() {
  local key="$1"
  [ -z "${CONF_FILE}" ] && exit "CONF_FILE is not defined"
  which deepin-installer-settings 1>/dev/null || \
    exit "deepin-installer-settings not found!"
  deepin-installer-settings get "${CONF_FILE}" "${key}"
}

installer_record_set(){
   #chroot /target
   local recordsession="$1"
   local recordkey="$2"
   local recordvalue="$3"
   [ -z "${EXPERIENCE_FILE}" ] && exit "EXPERIENCE_FILE is not defined"
   which deepin-installer-settings 1>/dev/null || \
     exit "deepin-installer-settings not found!"
   deepin-installer-settings set "${EXPERIENCE_FILE}" "${recordsession}" "${recordkey}" "${recordvalue}"
}

update_local() {
    local DI_LOCALE=$(installer_get "DI_LOCALE")
    DI_LOCALE=${DI_LOCALE:-en_US}

    export LANGUAGE=${DI_LOCALE}
    export LANG=${DI_LOCALE}.UTF-8
    export LC_ALL=
}

# update grub config by locale
update_grub_local() {
    update_local
    is_sw || /usr/sbin/update-grub
}

# Set value in conf file. Section name is ignored.
installer_set() {
  local key="$1"
  local value="$2"
  [ -z "${CONF_FILE}" ] && exit "CONF_FILE is not defined"
  which deepin-installer-settings 1>/dev/null || \
    exit "deepin-installer-settings not found!"
  deepin-installer-settings set "${CONF_FILE}" "${key}" "${value}"
}

# Check whether current platform is loongson or not.
is_loongson() {
  case $(uname -m) in
    loongson | mips* | loongarch64)
      return 0
      ;;
    *)
      return 1
      ;;
  esac
}

is_loongarch() {
  case $(uname -m) in
    loongarch64)
      return 0
      ;;
    *)
      return 1
      ;;
  esac
}


# Check whether current platform is sw or not.
is_sw() {
  case $(uname -m) in
    sw*)
      return 0
      ;;
    *)
      return 1
      ;;
  esac
}

# Check whether current platform is x86/x86_64 or not.
is_x86() {
  case $(uname -m) in
    i386 | i686 | amd64 | x86 | x86_64)
      return 0
      ;;
    *)
      return 1
      ;;
  esac
}

# Check whether current platform is arm64 or not.
is_arm64() {
  case $(uname -m) in
    arm64 | aarch64)
      return 0
      ;;
    *)
      return 1
      ;;
  esac
}

install_package() {
#  DEBIAN_FRONTEND="noninteractive" apt-get -y -o Dpkg::Options::="--force-confdef" -o Dpkg::Options::="--force-confold" --no-install-recommends --allow-unauthenticated install $@
  for i in $@;
  do
    DEBIAN_FRONTEND="noninteractive" apt-get -y -o Dpkg::Options::="--force-confdef" -o Dpkg::Options::="--force-confold" --no-install-recommends --allow-unauthenticated install $i
    if [ $? -eq 0 ]; then
      echo "succeed"
    else
      echo "Install Failed : $i"
    fi
  done
}

setup_lightdm_auto_login() {
  if [ x$(installer_get "lightdm_enable_auto_login") != "xtrue" ]; then
    return 0
  fi

  local USERNAME
  USERNAME=$(installer_get "DI_USERNAME")
  [ -f /etc/lightdm/lightdm.conf ] || warn_exit "lightdm.conf not found!"
  deepin-installer-simpleini set /etc/lightdm/lightdm.conf \
    "Seat:*" "autologin-user" "${USERNAME}"
}
