#ifndef UOS_RECOVERY_EVENT_DATA_H
#define UOS_RECOVERY_EVENT_DATA_H
#include <QString>
#include <QJsonObject>

namespace EventTid {
    // 已经申请的tid
    const int TID_SYSTEM_BACKUP  = 1000800000;
    const int TID_SYSTEM_RESTORE = 1000800001;
    const int TID_DATA_BACKUP    = 1000800002;
    const int TID_DATA_RESTORE   = 1000800003;
    const int TID_ADVANCED_GHOST = 1000800004;
}

struct ResultInfo {
    int errCode;
    QString result;
    QString errMsg;

    ResultInfo();
    ResultInfo(int retCode, const QString &resultInfo, const QString &errMsgInfo);
    ResultInfo(const ResultInfo &other);
    ResultInfo& operator=(const ResultInfo &other);
    QJsonObject marshal();
    void unmarshal(const QJsonObject &jsonObject);
};

struct EventBaseData {
    int tid; // 点位唯一ID，根据上报内容从附件中选择对应tid, 必填
    QString version; // 备份还原的版本号, 自动获取
    ResultInfo resInfo;

    EventBaseData();
    virtual QJsonObject marshal();
    virtual void unmarshal(const QJsonObject &jsonObject);
};

struct BackupEventData : public EventBaseData {
    QString operateType; // 系统备份 or 数据备份 ...
    QString backupType;  // 备份方式: rsync or ostree ...
    QString backupFinishedTime; // 备份完成时间

    BackupEventData();
    virtual QJsonObject marshal() override;
    virtual void unmarshal(const QJsonObject &jsonObject) override;
};

struct RestoreEventData : public EventBaseData {
    QString operateType; // 系统还原 or 数据还原 ...
    QString restoreType; // 还原方式: rsync or ostree ...

    RestoreEventData();
    virtual QJsonObject marshal() override;
    virtual void unmarshal(const QJsonObject &jsonObject) override;
};

struct GhostEventData : public EventBaseData {
    QString operateType; // Ghost 制作 ...

    GhostEventData();
    virtual QJsonObject marshal() override;
    virtual void unmarshal(const QJsonObject &jsonObject) override;
};

#endif
