/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ChainedPropertyUtil {
    public static final String UNDEFINED_PROPERTY_MESSAGE = "Undefined property: ";
    private static final Pattern PROPERTY_VARIABLE_PATTERN = Pattern.compile("\\$\\{([^\\s}]+)}");

    private ChainedPropertyUtil() {
    }

    public static Properties getResolvedProperties(Properties properties) throws CheckstyleException {
        HashSet<String> unresolvedPropertyNames = new HashSet<String>(properties.stringPropertyNames());
        Iterator unresolvedPropertyIterator = unresolvedPropertyNames.iterator();
        Properties comparisonProperties = new Properties();
        while (unresolvedPropertyIterator.hasNext()) {
            String propertyName = (String)unresolvedPropertyIterator.next();
            String propertyValue = properties.getProperty(propertyName);
            Matcher matcher = PROPERTY_VARIABLE_PATTERN.matcher(propertyValue);
            while (matcher.find()) {
                String propertyVariableExpression = matcher.group();
                String unresolvedPropertyName = ChainedPropertyUtil.getPropertyNameFromExpression(propertyVariableExpression);
                String resolvedPropertyValue = properties.getProperty(unresolvedPropertyName);
                if (resolvedPropertyValue == null) continue;
                propertyValue = propertyValue.replace(propertyVariableExpression, resolvedPropertyValue);
                properties.setProperty(propertyName, propertyValue);
            }
            if (ChainedPropertyUtil.allChainedPropertiesAreResolved(propertyValue)) {
                unresolvedPropertyIterator.remove();
            }
            if (unresolvedPropertyIterator.hasNext()) continue;
            if (comparisonProperties.equals(properties)) {
                throw new CheckstyleException(UNDEFINED_PROPERTY_MESSAGE + unresolvedPropertyNames);
            }
            comparisonProperties.putAll(properties);
            unresolvedPropertyIterator = unresolvedPropertyNames.iterator();
        }
        return properties;
    }

    private static String getPropertyNameFromExpression(String variableExpression) {
        int propertyStartIndex = variableExpression.lastIndexOf(123) + 1;
        int propertyEndIndex = variableExpression.lastIndexOf(125);
        return variableExpression.substring(propertyStartIndex, propertyEndIndex);
    }

    private static boolean allChainedPropertiesAreResolved(String propertyValue) {
        return !PROPERTY_VARIABLE_PATTERN.matcher(propertyValue).find();
    }
}

