// Copyright (C) 2019 ~ 2020 UnionTech Software Technology Co.,Ltd
// SPDX-FileCopyrightText: 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include <QtTest>
#include <QCoreApplication>
#include <QTest>

#include <gtest/gtest.h>
#include <gmock/gmock-matchers.h>
#ifndef __mips__
#include <sanitizer/asan_interface.h>
#endif

#include "window.h"
#include "application.h"

class QTestMain : public QObject
{
    Q_OBJECT

public:
    QTestMain(int &argc, char **argv);
    ~QTestMain();

private slots:
    void initTestCase();
    void cleanupTestCase();

    void testGTest();

private:
    int m_argc;
    char **m_argv;
};

QTestMain::QTestMain(int &argc, char **argv)
{
    m_argc = argc;
    m_argv = argv;
}

QTestMain::~QTestMain()
{

}

void QTestMain::initTestCase()
{
    qDebug() << "=====start test=====";
}

void QTestMain::cleanupTestCase()
{
    qDebug() << "=====stop test=====";
    exit(0);
}

void QTestMain::testGTest()
{
    testing::GTEST_FLAG(output) = "xml:./report/report_dmr-test.xml";
    testing::InitGoogleTest(&m_argc,m_argv);
    int ret = RUN_ALL_TESTS();
#ifndef __mips__
    __sanitizer_set_report_path("asan.log");
#endif
    Q_UNUSED(ret)

//    exit(0);
}

int main(int argc, char *argv[])
{
    Application app(argc, argv);
    app.setAttribute(Qt::AA_Use96Dpi, true);

    setlocale(LC_NUMERIC, "C");

    QTestMain testMain(argc, argv);
    Window w;
    w.play(QUrl("/data/source/deepin-movie-reborn/movie/demo.mp4"));

    app.setMainWindow(&w);
    QTest::qExec(&testMain, argc, argv);
    return app.exec();
}


#include "test_qtestmain.moc"
