// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef COMMAND_H
#define COMMAND_H

#include "global_header.h"

#include <QCommandLineParser>
#include <QCommandLineOption>
#include <QObject>

GLOBAL_BEGIN_NAMESPACE
class ModelRunner;
class Command : public QObject, public QCommandLineParser
{
    Q_OBJECT
public:
    explicit Command(QObject *parent = nullptr);
    int processCmd(const QCoreApplication &app);

signals:

public slots:
protected:
    int listHandler();
    int llmGenerate();
    int embeddings();
    int runServer();
    int stopServer();

    int loadModel(const QString &modelName, ModelRunner *runner);
private:
    static bool llmStreamOutput(const std::string &text, void *llm);
protected:
    void initOptions();

};

GLOBAL_END_NAMESPACE

#endif // COMMAND_H
