// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include "ovmodelconfig.h"

#include <QFile>
#include <QJsonDocument>
#include <QJsonObject>

GLOBAL_USE_NAMESPACE

OVModelConfig::OVModelConfig(const QString &file)
{
    QFile f(file);
    if (f.open(QFile::ReadOnly)) {
        auto doc = QJsonDocument::fromJson(f.readAll());
        configs = doc.object().toVariantHash();
    }
}

QStringList OVModelConfig::architectures() const
{
    return configs.value("architectures").toStringList();
}
