// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef LLMPROXY_H
#define LLMPROXY_H

#include "modelproxy.h"

#include <QVector>
#include <QVariantHash>

GLOBAL_BEGIN_NAMESPACE

typedef bool (*generateStream)(const std::string &out, void *user);

class LLMProxy : public ModelProxy
{
public:
    explicit LLMProxy();
    ModelArchitecture architecture() const override;
    virtual std::vector<int32_t> tokenize(const std::string &prompt, const std::map<std::string, std::string> &params = {}) = 0;
    virtual std::string detokenize(const std::vector<int32_t> &, const std::map<std::string, std::string> &params = {}) = 0;
    virtual std::vector<int32_t> generate(const std::vector<int32_t> &, const std::map<std::string, std::string> &params = {},  generateStream stream = nullptr, void *user = nullptr) const = 0;
};

GLOBAL_END_NAMESPACE

#endif // LLMPROXY_H
