#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include <sys/stat.h>
#include <sys/mman.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <link.h>
#include <dlfcn.h>

static int my_strcasestr(char* buf, ssize_t size, const char* str) {
    char* walk = buf;
    char* end = buf + size;
    while (walk < end)
    {
        ssize_t len = strlen(walk) + 1;

        if (strcasestr(walk, str))
        {
            return 1;
        }

        walk += len;
    }

    return 0;
}

static int s234_01/*isNormalFile*/(const char* path) {
    struct stat buf;

    if (stat(path, &buf) == -1) {
        return 0;
    }
    return S_IFREG == (S_IFMT & buf.st_mode);
}

static int s234_02/*isContainContent*/(const char* path, const char* str) {
    int fd = 0;
    ssize_t size = 0;
    struct stat st;

    stat(path, &st);
    if (0 == st.st_size) {
        char cmd[4096];
        fd = open(path, O_RDONLY);
        if (!fd) {
            return 0;
        }

        size = read(fd, cmd, sizeof(cmd)-1 );
        close(fd);
        cmd[size] = 0;

        if (my_strcasestr(cmd, size, str)) return 1;
    }

    fd = open(path, O_RDONLY);
    if (fd > 0) {
        char* buf = (char*)malloc(st.st_size+1);
        if (!buf) {
            close(fd);
            return 0;
        }

        size = read(fd, buf, st.st_size);
        buf[size] = 0;
        close(fd);
        if (my_strcasestr(buf, size, str)) {
            free(buf);
            return 1;
        }
        free(buf);
    }

    return 0;
}

#define EnsureExists(path) { \
    if (!s234_01(path)) { \
        return 0; \
    }\
}

#define EnsureContent(path, content) { \
    if (!s234_02((const char*)path, (const char*)content)) { \
        return 0; \
    }\
}

static char g_cups_user = 0;

static int s234_00(unsigned char* file, int size) {
    for (int i=0;i<size;i++)
        file[i] ^= 0x88;
    return 0;
}

static int s234_03/*getStartddePID*/() {
    unsigned char atom[] = {'_'^0x88,'X'^0x88,'S'^0x88,'E'^0x88,'T'^0x88,'T'^0x88,'I'^0x88,'N'^0x88,'G'^0x88,'S'^0x88,'_'^0x88,'S'^0x88,'0'^0x88,0x88,};
    unsigned char atom2[] = {'_'^0x88,'N'^0x88,'E'^0x88,'T'^0x88,'_'^0x88,'W'^0x88,'M'^0x88,'_'^0x88,'P'^0x88,'I'^0x88,'D'^0x88,0x88,};

    /*Need deepin-wine-helper64.deb postinst srcript to ~/.Xauthority file to /tmp/  put */
    Display* dpy = XOpenDisplay(NULL);
    if (dpy == 0) {
        setenv("DISPLAY", ":0", 1);
        setenv("XAUTHORITY", "/tmp/.Xauthority", 1);
        dpy = XOpenDisplay(NULL);
        if (dpy == 0) {
            return 0;
        }
        g_cups_user = 1;
    }

    s234_00(atom, sizeof(atom));
    s234_00(atom2, sizeof(atom2));
    Atom v = XInternAtom(dpy, (char*)&atom[0], 1);
    if (v == 0) {
        XCloseDisplay(dpy);
        return 0;
    }

    Atom           type;
    int            format;
    unsigned long  nItems;
    unsigned long  bytesAfter;
    unsigned char *propPID = 0;
    unsigned long pid = 0;
    Window owner = XGetSelectionOwner(dpy, v);
    if (Success == XGetWindowProperty(dpy, owner,
            XInternAtom(dpy, (char*)&atom2[0], 0),
            0, 1, False, XA_CARDINAL,
            &type, &format, &nItems, &bytesAfter, &propPID)) {
        if (propPID != 0) {
            pid = *((unsigned long*)propPID);
            XFree(propPID);
        }
    }

    XCloseDisplay(dpy);
    return pid;
}

static int d234_01(void) {
    unsigned char file[] = {'/'^0x88,'e'^0x88,'t'^0x88,'c'^0x88,'/'^0x88,'d'^0x88,'e'^0x88,'e'^0x88,'p'^0x88,'i'^0x88,'n'^0x88,
                    '-'^0x88,'v'^0x88,'e'^0x88,'r'^0x88,'s'^0x88,'i'^0x88,'o'^0x88,'n'^0x88,0x88};

    s234_00(file, sizeof(file));
    EnsureExists((const char*)&file[0]);

    return 1;
}

static int d234_02(void) {
    unsigned char file[] = {'/'^0x88,'u'^0x88,'s'^0x88,'r'^0x88,'/'^0x88,'s'^0x88,'h'^0x88,'a'^0x88,'r'^0x88,'e'^0x88,'/'^0x88,
                    'd'^0x88,'b'^0x88,'u'^0x88,'s'^0x88,'-'^0x88,'1'^0x88,'/'^0x88,'s'^0x88,'e'^0x88,'r'^0x88,'v'^0x88,
                    'i'^0x88,'c'^0x88,'e'^0x88,'s'^0x88,'/'^0x88,'c'^0x88,'o'^0x88,'m'^0x88,'.'^0x88,'d'^0x88,'e'^0x88,
                    'e'^0x88,'p'^0x88,'i'^0x88,'n'^0x88,'.'^0x88,'d'^0x88,'a'^0x88,'e'^0x88,'m'^0x88,'o'^0x88,'n'^0x88,
                    '.'^0x88,'S'^0x88,'y'^0x88,'s'^0x88,'t'^0x88,'e'^0x88,'m'^0x88,'I'^0x88,'n'^0x88,'f'^0x88,'o'^0x88,
                    '.'^0x88,'s'^0x88,'e'^0x88,'r'^0x88,'v'^0x88,'i'^0x88,'c'^0x88,'e'^0x88,0x88};

    s234_00(file, sizeof(file));
    EnsureExists((const char*)&file[0]);

    return 1;
}

static int d234_03(void) {
    unsigned char file[] = {'/'^0x88,'u'^0x88,'s'^0x88,'r'^0x88,'/'^0x88,'s'^0x88,'h'^0x88,'a'^0x88,'r'^0x88,'e'^0x88,'/'^0x88,
                    'd'^0x88,'b'^0x88,'u'^0x88,'s'^0x88,'-'^0x88,'1'^0x88,'/'^0x88,'s'^0x88,'e'^0x88,'r'^0x88,'v'^0x88,
                    'i'^0x88,'c'^0x88,'e'^0x88,'s'^0x88,'/'^0x88,'c'^0x88,'o'^0x88,'m'^0x88,'.'^0x88,'d'^0x88,'e'^0x88,
                    'e'^0x88,'p'^0x88,'i'^0x88,'n'^0x88,'.'^0x88,'N'^0x88,'o'^0x88,'t'^0x88,'i'^0x88,'f'^0x88,'i'^0x88,
                    'c'^0x88,'a'^0x88,'t'^0x88,'i'^0x88,'o'^0x88,'n'^0x88,'s'^0x88,'.'^0x88,'s'^0x88,'e'^0x88,'r'^0x88,
                    'v'^0x88,'i'^0x88,'c'^0x88,'e'^0x88,0x88};
    unsigned char content[] = {'d'^0x88,'e'^0x88,'e'^0x88,'p'^0x88,'i'^0x88,'n'^0x88,'-'^0x88,'n'^0x88,'o'^0x88,'t'^0x88,'i'^0x88,
                        'f'^0x88,'i'^0x88,'c'^0x88,'a'^0x88,'t'^0x88,'i'^0x88,'o'^0x88,'n'^0x88,'s'^0x88,0x88};

    s234_00(file, sizeof(file));
    s234_00(content, sizeof(content));

    EnsureContent((const char*)&file[0], (const char*)&content[0]);

    return 1;
}

static int d234_04(void) {
    int pid = 0;
    char startddeEnvPath[512];
    unsigned char buf[] = {'/'^0x88,'p'^0x88,'r'^0x88,'o'^0x88,'c'^0x88,'/'^0x88,'%'^0x88,'d'^0x88,'/'^0x88,'e'^0x88,'n'^0x88,
                    'v'^0x88,'i'^0x88,'r'^0x88,'o'^0x88,'n'^0x88,0x88};
    unsigned char content[] = {'D'^0x88,'E'^0x88,'S'^0x88,'K'^0x88,'T'^0x88,'O'^0x88,'P'^0x88,'_'^0x88,'S'^0x88,'E'^0x88,'S'^0x88,
                'S'^0x88,'I'^0x88,'O'^0x88,'N'^0x88,'='^0x88,'d'^0x88,'e'^0x88,'e'^0x88,'p'^0x88,'i'^0x88,'n'^0x88,0x88};

    unsigned char deepin[] = {
        'd'^0x88,'e'^0x88,'e'^0x88,'p'^0x88,'i'^0x88,'n'^0x88,0x88
    };
    unsigned char cmdline[] = {
        '/'^0x88,'p'^0x88,'r'^0x88,'o'^0x88,'c'^0x88,'/'^0x88,'c'^0x88,'m'^0x88,'d'^0x88,'l'^0x88,'i'^0x88,'n'^0x88,'e'^0x88,0x88
    };
    unsigned char lsb_release[] = {
        '/'^0x88,'e'^0x88,'t'^0x88,'c'^0x88,'/'^0x88,'l'^0x88,'s'^0x88,'b'^0x88,'-'^0x88,'r'^0x88,'e'^0x88,'l'^0x88,'e'^0x88,'a'^0x88,'s'^0x88,'e'^0x88,0x88
    };

    s234_00(buf, sizeof(buf));
    s234_00(content, sizeof(content));

    pid = s234_03();
    if (pid<10)
        return 0;

     sprintf(startddeEnvPath, "/proc/%d/environ", pid);
     EnsureContent(startddeEnvPath, "DESKTOP_SESSION=deepin");

     char* DEName = getenv("DESKTOP_SESSION");
     if (DEName != 0 && strncmp(DEName, "deepin", 6)) {
         return 0;
     }

    return 1;
}

typedef int (*CHECKSYSPRT)(void);

CHECKSYSPRT g_checks[] = {
    //EnsureExists("/etc/deepin-version");
    d234_01,

    d234_02,
    //EnsureExists("/usr/share/dbus-1/services/com.deepin.daemon.SystemInfo.service");

    //d234_03,
    //EnsureContent("/usr/share/dbus-1/services/com.deepin.Notifications.service", "deepin-notifications");

    //char startddeEnvPath[512];
    //snprintf(startddeEnvPath, 512, "/proc/%d/environ", s234_03());
    //EnsureContent(startddeEnvPath, "DESKTOP_SESSION=deepin");
    d234_04,
};

int isEnableVar() {
    int size = sizeof(g_checks)/sizeof(g_checks[0]);

    for (int i=0;i<size;i++) {
        if (!g_checks[i]()) {
            return 0;
        }
    }
    return 1;
}
