% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_as_csv.R
\name{write_as_csv}
\alias{write_as_csv}
\alias{save_as_csv}
\title{Save Twitter data as a comma separated value file.}
\usage{
write_as_csv(x, file_name, prepend_ids = TRUE, na = "", fileEncoding = "UTF-8")

save_as_csv(x, file_name, prepend_ids = TRUE, na = "", fileEncoding = "UTF-8")
}
\arguments{
\item{x}{Data frame returned by an rtweet function.}

\item{file_name}{Desired name to save file as. If \code{file_name} does not
include the extension ".csv" it will be added automatically.}

\item{prepend_ids}{Logical indicating whether to prepend an "x"
before all Twitter IDs (for users, statuses, lists, etc.). It's
recommended when saving to CSV as these values otherwise get
treated as numeric and as a result the values are often less
precise due to rounding or other class-related quirks. Defaults
to true.}

\item{na}{Value to be used for missing (NA)s. Defaults to empty
character, "".}

\item{fileEncoding}{Encoding to be used when saving to
CSV. defaults to "UTF-8".}
}
\value{
Saved CSV files in current working directory.
}
\description{
Saves as flattened CSV file of Twitter data.
}
\seealso{
Other datafiles: 
\code{\link{flatten}()},
\code{\link{read_twitter_csv}()}

Other datafiles: 
\code{\link{flatten}()},
\code{\link{read_twitter_csv}()}
}
\concept{datafiles}
