% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterRMSD.R
\name{clusterRMSD}
\alias{clusterRMSD}
\title{Compute the RMSD per cluster}
\usage{
clusterRMSD(x, clusters, sum = FALSE)
}
\arguments{
\item{x}{Numeric matrix containing observations in rows and variables in columns.}

\item{clusters}{Vector containing the assigned cluster for each observation.}

\item{sum}{Logical scalar indicating whether to compute the sum of squares.}
}
\value{
Numeric vector of RMSD values per cluster.
If \code{sum=TRUE}, a numeric vector of the sum of squares per cluster is returned instead.
}
\description{
Compute the root mean-squared deviation (RMSD) for each cluster.
}
\details{
The RMSD for each cluster is a measure of its dispersion;
clusters with large internal heterogeneity will have high RMSDs and are good candidates for further subclustering.
}
\examples{
x <- matrix(rnorm(10000), ncol=10)
kout <- kmeans(x, 5)
clusterRMSD(x, kout$cluster)

}
\author{
Aaron Lun
}
