/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: shaozhimin <shaozhimin@kylinos.cn>
 *
 */

#ifndef	KYSDK_BASE_GSETTINGS_H__
#define	KYSDK_BASE_GSETTINGS_H__


#ifdef	__cplusplus
extern "C"
{

#endif
/**
 * @brief 设置gesettings指定key值
 * 
 * @return int 成功返回1
 */
extern int kdk_gsettings_set(const char *schema_id, const char *key, const char *format, ...);

/**
 * @brief 重置gesettings指定key值
 * 
 * @return int 成功返回0
 */
extern int	kdk_settings_reset(const char *schema_id, const char *key);

/**
 * @brief 设置gesettings指定string类型key值
 * 
 * @return int 成功返回0
 */
extern int kdk_settings_set_string(const char *schema_id, const char *key, const char *value);

/**
 * @brief 设置gesettings指定int类型key值
 * 
 * @return int 成功返回0
 */
extern int kdk_settings_set_int(const char *schema_id, const char *key, int value);

/**
 * @brief 获取gesettings指定key值
 * 
 * @return GVariant key的值
 */
void* kdk_gsettings_get(const char *schema_id, const char *key, const char *format, ...);

/**
 * @brief 获取gesettings指定string类型key值
 * 
 * @return char* key的值
 */
extern char* kdk_settings_get_string(const char *schema_id, const char *key);

/**
 * @brief 获取gesettings指定int类型key值
 * 
 * @return int key的值
 */
extern int kdk_settings_get_int(const char *schema_id, const char *key);

/**
 * @brief 获取gesettings指定double类型key值
 * 
 * @return int key的值
 */
extern double kdk_settings_get_double(const char *schema_id, const char *key);

#ifdef	__cplusplus
}
#endif

#endif	//KYSDK_BASE_GSETTINGS_H__
