/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <iostream>
#include <gtest/gtest.h>
#include <QDebug>

#include "dwmjack.h"

class TestWMJack : public ::testing::Test
{
public:
    static void SetUpTestCase() {
        m_wmJack = new DWMJack();
    }

    static void TearDownTestCase() {
        delete m_wmJack;
        m_wmJack = nullptr;
    }

    void SetUp() override {}
    void TearDown() override {}
   
    static DWMJack *m_wmJack;
};

DWMJack *TestWMJack::m_wmJack = nullptr;

TEST_F(TestWMJack, desktopWindowID)
{
    WindowId ret = m_wmJack->GetDesktopWindowID();
    ASSERT_NE(ret, 0);
}

TEST_F(TestWMJack, windowText)
{
    WindowId wid = m_wmJack->GetDesktopWindowID();
    char * ret = m_wmJack->GetWindowText(wid);
    ASSERT_STREQ(ret, "桌面");
}

TEST_F(TestWMJack, windowSize)
{
    WindowId wid = m_wmJack->GetDesktopWindowID();
    Size ret = m_wmJack->GetWindowSize(wid);
    ASSERT_NE(ret.w, -1);
    ASSERT_NE(ret.h, -1);
}

TEST_F(TestWMJack, windowPosition)
{
    WindowId wid = m_wmJack->GetDesktopWindowID();
    Position ret = m_wmJack->GetWindowPosition(wid);
    ASSERT_NE(ret.x, -1);
    ASSERT_NE(ret.y, -1);
}

TEST_F(TestWMJack, toggleMultitaskView)
{
    int ret = m_wmJack->ToggleMultitaskView();
    m_wmJack->ToggleMultitaskView();
    ASSERT_EQ(ret, 0);
}

TEST_F(TestWMJack, windowChildren)
{
    WindowId wid = m_wmJack->GetDesktopWindowID();
    WindowId *child;
    int ret = m_wmJack->GetWindowChildren(wid, &child);
    ASSERT_EQ(ret, 0);
    m_wmJack->FreeWindowList(child);
}

TEST_F(TestWMJack, pointerPosition)
{
    Position ret = m_wmJack->GetPointerPosition();
    ASSERT_NE(ret.x, -1);
    ASSERT_NE(ret.y, -1);
}

TEST_F(TestWMJack, windowPID)
{
    WindowId wid = m_wmJack->GetDesktopWindowID();
    int ret = m_wmJack->GetWindowPID(wid);
    ASSERT_NE(ret, -1);
}

TEST_F(TestWMJack, activeWindowID)
{
    WindowId ret = m_wmJack->GetActiveWindowID();
    ASSERT_NE(ret, 0);
}

TEST_F(TestWMJack, maximizeWindow)
{
    WindowId wid = m_wmJack->GetActiveWindowID();
    int ret = m_wmJack->MaximizeWindow(wid);
    ASSERT_EQ(ret, 0);
}

TEST_F(TestWMJack, minimizeWindow)
{
    WindowId wid = m_wmJack->GetActiveWindowID();
    int ret = m_wmJack->MinimizeWindow(wid);
    ASSERT_EQ(ret, 0);
}

TEST_F(TestWMJack, compositorSwitchStatus)
{
    m_wmJack->GetCompositorSwitchStatus();
}








