/*
 * Copyright (C) 2023 Uniontech Technology Co., Ltd.
 *
 * Author:     zhijie geng <gengzhijie@uniontech.com>
 *
 * Maintainer: zhijie geng <gengzhiejie@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DISPLAYJACK_SESSIONMANAGER_CLIENT_H_
#define DISPLAYJACK_SESSIONMANAGER_CLIENT_H_

#include <qmetatype.h>
#include <qtextstream.h>
#include <qdatastream.h>
#include <QSocketNotifier>
#include <QObject>
#include <QCoreApplication>

#include <unordered_map>

#include <X11/SM/SMlib.h>

class USMClient : public QObject
{
public:
    USMClient();
    USMClient(unsigned long long wid);

    SmcConn connection() const {
        return m_conn;
    }

public slots:
    void processData();

private:
    SmcConn m_conn;
    QSocketNotifier *m_notifier;
};

typedef struct
{
    USMClient *client;
    SmcCallbacks callbacks;
    struct timeval tv;
    struct passwd *entry;
    std::string program;
    std::unordered_map<unsigned long long, std::string> fullFilenames;
    char *clientId;
    char *previousId;
    char processName[4096];
} UsmData;

extern UsmData *data;

enum USM_ERROR_TYPE {
    NO_ERROR,
    ERR_NORMAL,
    ERR_PARAMSTER_NOT_MATCH,
    ERR_LESS_PARAMSTER,
    ERR_NULL_POINTER,
    ERR_NO_ATOM_REPLY,
    ERR_SYSTEM_CALL
};

#endif