/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef WAYLAND_DND_H
#define WAYLAND_DND_H

#include "dnd_security.h"
#include <pthread.h>

typedef struct _Wayland_Dnd_Backend {
    struct wl_display *display;
    pthread_mutex_t cond_lock;
    pthread_t dispatch;
    bool lock;

    void *dde_security;
    void *client_management;
} WaylandDndBackend;
typedef struct _Wayland_Dnd_Backend *WaylandDndBackendPtr;

int initWaylandDnd();

void destoryWaylandDnd();

int wGetSecuritySession(SessionType types);

int wDestroySecuritySession(int session);

void wReportSecurityVerified(int session, Permission result);

struct dtk_array* wGetSecurityClients();

#endif
