/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef H_SECURITY_TOOL_H_H
#define H_SECURITY_TOOL_H_H

#include <QObject>
#include <QString>
#include <QVector>

class SecurityTool : public QObject
{
    Q_OBJECT
public:
    SecurityTool(QObject *parent);
    ~SecurityTool();

    int setPermission(int permission);
    int permission() { return m_permission; }

    QString dump();

private:
    int m_sessionId;
    int m_permission;

    QVector<QString> m_verifiyLog;

    static int handleSecurityVerify(void *data, int types, int client, int target);
    int doSecurityVerify(int types, int client, int target);
};

#endif