# Copyright (c) 2012 Linaro Ltd.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

import os
import subprocess
import unittest

import utils


@unittest.skipUnless(utils.file_on_path('pyflakes', os.environ['PATH']),
                     "pyflakes not found")
class TestPyflakes(unittest.TestCase):
    def test_pyflakes(self):
        # ignore return code
        proc = subprocess.Popen(
            ['pyflakes', '.'],
            stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        (stdout, stderr) = proc.communicate()
        self.assertEqual(b'', stdout)
        self.assertEqual(b'', stderr)
