/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSPROCMIME_H__
#define __UOSPROCMIME_H__

#include "libsylph/procmime.h"

typedef MimeType UosMimeType;
typedef MailCap UosMailCap;
typedef MimeInfo UosMimeInfo;

#include "uosutils.h"
#include "uosprocmsg.h"

typedef EncodingType UosEncodingType;
#define UosENC_7BIT ENC_7BIT
#define UosENC_8BIT ENC_8BIT
#define UosENC_QUOTED_PRINTABLE ENC_QUOTED_PRINTABLE
#define UosENC_BASE64 ENC_BASE64
#define UosENC_X_UUENCODE ENC_X_UUENCODE
#define UosENC_UNKNOWN ENC_UNKNOWN

typedef ContentType UosContentType;
#define UosMIME_TEXT MIME_TEXT
#define UosMIME_TEXT_HTML MIME_TEXT_HTML
#define UosMIME_MESSAGE_RFC822 MIME_MESSAGE_RFC822
#define UosMIME_APPLICATION MIME_APPLICATION
#define UosMIME_APPLICATION_OCTET_STREAM MIME_APPLICATION_OCTET_STREAM
#define UosMIME_MULTIPART MIME_MULTIPART
#define UosMIME_IMAGE MIME_IMAGE
#define UosMIME_AUDIO MIME_AUDIO
#define UosMIME_VIDEO MIME_VIDEO
#define UosMIME_CALENDAR MIME_CALENDAR
#define UosMIME_UNKNOWN MIME_UNKNOWN

#define UOSIS_BOUNDARY(s, bnd, len) IS_BOUNDARY(s, bnd, len)


UosMimeInfo *uos_procmime_mimeinfo_new     (void);
void uos_procmime_mimeinfo_free_all     (UosMimeInfo   *mimeinfo);

UosMimeInfo *uos_procmime_mimeinfo_insert  (UosMimeInfo   *parent,
                                     UosMimeInfo   *mimeinfo);

UosMimeInfo *uos_procmime_mimeinfo_next    (UosMimeInfo   *mimeinfo);

UosMimeInfo *uos_procmime_scan_message     (UosMsgInfo    *msginfo);
UosMimeInfo *uos_procmime_scan_message_stream  (FILE       *fp);
void uos_procmime_scan_multipart_message    (UosMimeInfo   *mimeinfo,
                                         FILE       *fp);

void uos_procmime_scan_encoding     (UosMimeInfo   *mimeinfo,
                                 const gchar    *encoding);
void uos_procmime_scan_content_type     (UosMimeInfo   *mimeinfo,
                                     const gchar    *content_type);
void uos_procmime_scan_content_type_str (const gchar    *content_type,
                                     gchar         **mime_type,
                                     gchar         **charset,
                                     gchar         **name,
                                     gchar         **boundary,
                                     gchar         **method);
void uos_procmime_scan_content_type_partial (const gchar    *content_type,
                                         gint       *total,
                                         gchar         **part_id,
                                         gint       *number);
void uos_procmime_scan_content_id  (UosMimeInfo   *mimeinfo,
                                const gchar    *content_id);
void uos_procmime_scan_content_disposition  (UosMimeInfo   *mimeinfo,
                                         const gchar    *content_disposition);
UosMimeInfo *uos_procmime_scan_mime_header (FILE       *fp);

FILE *uos_procmime_decode_content       (FILE       *outfp,
                                     FILE       *infp,
                                     UosMimeInfo   *mimeinfo);
gint uos_procmime_get_part          (const gchar    *outfile,
                                 const gchar    *infile,
                                 UosMimeInfo   *mimeinfo);
gint uos_procmime_get_part_fp       (const gchar    *outfile,
                                 FILE       *infp,
                                 UosMimeInfo   *mimeinfo);
FILE *uos_procmime_get_part_fp_fp       (FILE       *outfp,
                                     FILE       *infp,
                                     UosMimeInfo   *mimeinfo);
gint uos_procmime_get_all_parts     (const gchar    *dir,
                                 const gchar    *infile,
                                 UosMimeInfo   *mimeinfo);
FILE *uos_procmime_get_text_content     (UosMimeInfo   *mimeinfo,
                                     FILE       *infp,
                                     const gchar    *encoding);
FILE *uos_procmime_get_first_text_content   (UosMsgInfo    *msginfo,
                                         const gchar    *encoding);

gboolean uos_procmime_find_string_part  (UosMimeInfo   *mimeinfo,
                                     const gchar    *filename,
                                     const gchar    *str,
                                     UosStrFindFunc     find_func);
gboolean uos_procmime_find_string       (UosMsgInfo    *msginfo,
                                     const gchar    *str,
                                     UosStrFindFunc     find_func);

gchar *uos_procmime_get_part_file_name  (UosMimeInfo   *mimeinfo);
gchar *uos_procmime_get_tmp_file_name   (UosMimeInfo   *mimeinfo);
gchar *uos_procmime_get_tmp_file_name_for_user
(UosMimeInfo   *mimeinfo);

UosContentType uos_procmime_scan_mime_type (const gchar    *mime_type);
gchar *uos_procmime_get_mime_type       (const gchar    *filename);

gint uos_procmime_execute_open_file     (const gchar    *file,
                                     const gchar    *mime_type);

UosEncodingType uos_procmime_get_encoding_for_charset  (const gchar    *charset);
UosEncodingType uos_procmime_get_encoding_for_text_file(const gchar    *file);
UosEncodingType uos_procmime_get_encoding_for_str  (const gchar    *str);
const gchar *uos_procmime_get_encoding_str      (UosEncodingType    encoding);

#endif /* __UOSPROCMIME_H__ */
