/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSDEFS_H__
#define __UOSDEFS_H__
#include "libsylph/defs.h"

#define UOSINBOX_DIR INBOX_DIR
#define UOSOUTBOX_DIR OUTBOX_DIR
#define UOSQUEUE_DIR QUEUE_DIR
#define UOSDRAFT_DIR DRAFT_DIR
#define UOSTRASH_DIR TRASH_DIR
#define UOSJUNK_DIR JUNK_DIR
#define UOSIMPORTANT_DIR IMPORTANT_DIR
#define UOSUNREAD_DIR UNREAD_DIR
#define UOSARCHIVE_DIR ARCHIVE_DIR
#if defined(G_OS_WIN32) || defined(__APPLE__)
#define UOSRC_DIR RC_DIR
#else
#define UOSRC_DIR RC_DIR
#define UOSRC_DIR_MIDDLE RC_DIR_MIDDLE
#endif
#define UOSOLD_RC_DIR OLD_RC_DIR
#define UOSNEWS_CACHE_DIR NEWS_CACHE_DIR
#define UOSIMAP_CACHE_DIR IMAP_CACHE_DIR
#define UOSPOP_CACHE_DIR POP_CACHE_DIR
#define UOSMIME_TMP_DIR MIME_TMP_DIR
#define UOSCOMMON_RC COMMON_RC
#define UOSACCOUNT_RC ACCOUNT_RC
#define UOSFILTER_RC FILTER_RC
#define UOSFILTER_LIST FILTER_LIST
#define UOSFILTER_HEADER_RC FILTER_HEADER_RC
#define UOSCUSTOM_HEADER_RC CUSTOM_HEADER_RC
#define UOSDISPLAY_HEADER_RC DISPLAY_HEADER_RC
#define UOSMENU_RC MENU_RC
#define UOSACTIONS_RC ACTIONS_RC
#define UOSCOMMAND_HISTORY COMMAND_HISTORY
#define UOSTEMPLATE_DIR TEMPLATE_DIR
#define UOSTMP_DIR TMP_DIR
#define UOSUIDL_DIR UIDL_DIR
#define UOSPLUGIN_DIR PLUGIN_DIR
#define UOSNEWSGROUP_LIST NEWSGROUP_LIST
#define UOSADDRESS_BOOK ADDRESS_BOOK
#define UOSMANUAL_HTML_INDEX MANUAL_HTML_INDEX
#define UOSFAQ_HTML_INDEX FAQ_HTML_INDEX
#define UOSHOMEPAGE_URI HOMEPAGE_URI
#define UOSDOWNLOAD_URI DOWNLOAD_URI
#define UOSVERSION_URI VERSION_URI
#define UOSPLUGIN_HOMEPAGE_URI PLUGIN_HOMEPAGE_URI
#define UOSPLUGIN_VERSION_URI PLUGIN_VERSION_URI
#define UOSFOLDER_LIST FOLDER_LIST
#define UOSCACHE_FILE CACHE_FILE
#define UOSMARK_FILE MARK_FILE
#define UOSSEARCH_CACHE SEARCH_CACHE
#define UOSBACKUP_CACHE BACKUP_CACHE
#define UOSBACKUP_MARK  BACKUP_MARK
#define UOSCACHE_VERSION CACHE_VERSION
#define UOSMARK_VERSION MARK_VERSION
#define UOSSEARCH_CACHE_VERSION SEARCH_CACHE_VERSION

#ifdef G_OS_WIN32
#define UOSREMOTE_CMD_PORT REMOTE_CMD_PORT
#endif

#ifdef G_OS_WIN32
#define UOSDEFAULT_SIGNATURE DEFAULT_SIGNATURE
#else
#define UOSDEFAULT_SIGNATURE DEFAULT_SIGNATURE
#endif
#define UOSDEFAULT_INC_PATH DEFAULT_INC_PATH
#define UOSDEFAULT_INC_PROGRAM DEFAULT_INC_PROGRAM

#define UOSDEFAULT_SENDMAIL_CMD DEFAULT_SENDMAIL_CMD
#ifdef __APPLE__
#define UOSDEFAULT_BROWSER_CMD DEFAULT_BROWSER_CMD
#else
#define UOSDEFAULT_BROWSER_CMD DEFAULT_BROWSER_CMD
#endif

#define UOSDEFAULT_SPOOL_PATH DEFAULT_SPOOL_PATH

#define UOSBUFFSIZE BUFFSIZE

#define UOSMAXPATHLEN MAXPATHLEN

#define UOSDEFAULT_HEIGHT DEFAULT_HEIGHT
#define UOSDEFAULT_FOLDERVIEW_WIDTH DEFAULT_FOLDERVIEW_WIDTH
#define UOSDEFAULT_MAINVIEW_WIDTH DEFAULT_MAINVIEW_WIDTH
#define UOSDEFAULT_SUMMARY_HEIGHT DEFAULT_SUMMARY_HEIGHT
#define UOSDEFAULT_HEADERVIEW_HEIGHT DEFAULT_HEADERVIEW_HEIGHT
#define UOSDEFAULT_COMPOSE_HEIGHT DEFAULT_COMPOSE_HEIGHT
#define UOSBORDER_WIDTH BORDER_WIDTH
#define UOSCTREE_INDENT CTREE_INDENT
#define UOSFOLDER_SPACING FOLDER_SPACING
#define UOSMAX_ENTRY_LENGTH MAX_ENTRY_LENGTH
#define UOSCOLOR_DIM COLOR_DIM
#define UOSUI_REFRESH_INTERVAL UI_REFRESH_INTERVAL
#define UOSFOLDER_UPDATE_INTERVAL FOLDER_UPDATE_INTERVAL
#define UOSPROGRESS_UPDATE_INTERVAL PROGRESS_UPDATE_INTERVAL
#define UOSSESSION_TIMEOUT_INTERVAL SESSION_TIMEOUT_INTERVAL
#define UOSMAX_HISTORY_SIZE MAX_HISTORY_SIZE

#define UOSDEFAULT_MESSAGE_FONT DEFAULT_MESSAGE_FONT

#endif /* __UOSDEFS_H__ */
