#include "btinfodialog.h"

#include <QDir>
#include <QFont>
#include <QProcess>

#include <DHeaderView>
#include <DFileDialog>
#include <DMessageBox>
#include "messagebox.h"
#include <QPixmap>

BtInfoDialog::BtInfoDialog(QString torrentFile, QString bt_last_save_path)
    :DDialog ()
{
    this->torrentFile = torrentFile;
    this->defaultDownloadDir = bt_last_save_path;
    this->setFixedSize(500, 525);

    this->setIcon(QIcon::fromTheme("ndm_preferencesystem"));
    initUI();
    connect(DGuiApplicationHelper::instance(), &DGuiApplicationHelper::paletteTypeChanged, this, &BtInfoDialog::slot_paletteTypeChanged);
}

BtInfoDialog::~BtInfoDialog() {
    delete model;
    delete delegate;

    delete tableView;

    delete btnOK;

    delete labelTitle;
    delete labelSelectedFileNum;
    delete labelFileSize;
    delete labelCapacityFree;

    delete labelInfoName;
    delete editDir;

    delete checkAll;
    delete checkVideo;
    delete checkAudio;
    delete checkPicture;
    delete checkOther;

    delete widget;
}

QString BtInfoDialog::getSelected()
{
    QString selected = "";
    for(int i = 0;i < model->rowCount();i++) {
        QString checked =  model->data(model->index(i, 0)).toString();
        if(checked == "1") {
            QString index = model->data(model->index(i, 4)).toString();
            selected += index;
            selected += ",";
        }
    }
    return selected.mid(0, selected.length() - 1);
}

QString BtInfoDialog::getSaveto()
{
    return this->editDir->text();
}

QString BtInfoDialog::getName()
{
    return this->labelInfoName->text();
}

Aria2cBtInfo BtInfoDialog::getBtInfo()
{
    return this->info;
}

void BtInfoDialog::initUI()
{
    info = Aria2cInterface::getBtInfo(this->torrentFile);
    //
    this->setTitle(" ");
    //this->setWindowTitle(tr("Magnet/Torrent Files Select"));

    this->labelTitle = new DLabel(this);
    this->labelTitle->setFixedSize(this->width(), 30);
    this->labelTitle->setAlignment(Qt::AlignCenter);
    this->labelTitle->move(0, 48);
    this->labelTitle->setText(tr("Magnet/Torrent Files Select"));

    this->folderIcon = new DLabel(this);
    this->folderIcon->setPixmap(QPixmap(":/icons/deepin/builtin/light/icons/folder.svg"));///usr/share/icons/bloom/places/32/folder.svg
    this->folderIcon->move(45, 92);

    //下载信息名称
    this->labelInfoName = new DLabel(this);
    this->labelInfoName->setGeometry(85, 89, 356, 40);
    this->labelInfoName->setText(info.name);
    this->labelInfoName->setWordWrap(true);

    //总大小标签
    QFont font2;
    font2.setPixelSize(12);
    QPalette pal;
    pal.setColor(QPalette::WindowText, QColor("#8AA1B4"));
    this->labelFileSize = new DLabel(this);
    //this->labelFileSize->setGeometry(370, 365, 113, 23);
    //this->labelFileSize->setFixedHeight(23);
    this->labelFileSize->setText(tr("Size:") + Aria2cInterface::bytesFormat(this->info.totalLengthByets));
    this->labelFileSize->setAlignment(Qt::AlignRight);
    this->labelFileSize->setFont(font2);
    this->labelFileSize->setPalette(pal);

    //选中文件数
    this->labelSelectedFileNum = new DLabel(this);
    //this->labelSelectedFileNum->setGeometry(15, 365, 196, 23);
    //this->labelSelectedFileNum->setFixedHeight(23);
    this->labelSelectedFileNum->setText(tr("Selected Files:") + QString::number(info.files.size()) + tr(",Total ") + Aria2cInterface::bytesFormat(this->info.totalLengthByets));
    this->labelSelectedFileNum->setFont(font2);
    this->labelSelectedFileNum->setPalette(pal);

    //文件列表
    this->widget = new DWidget(this);
    this->tableView = new BtInfoTableView(widget);
    //this->tableView->setGeometry(15, 142, 471, 221);
    this->tableView->setMouseTracking(true);
    this->widget->setGeometry(15, 142, 471, 255);
    this->widget->setAutoFillBackground(true);
    /*QPalette p;
    p.setColor(QPalette::Background, Qt::white);
    this->widget->setPalette(p);*/

    QVBoxLayout *vb = new QVBoxLayout(widget);
    vb->setContentsMargins(10, 0, 10, 6);
    vb->addWidget(tableView);
    QHBoxLayout *hb = new QHBoxLayout();
    hb->addWidget(labelSelectedFileNum, Qt::AlignLeft);
    hb->addWidget(labelFileSize, Qt::AlignRight);
    vb->addLayout(hb);

    //Checkbox
    this->checkAll = new DCheckBox(this);
    this->checkAll->setGeometry(15, 401, 95, 29);
    this->checkAll->setText(tr("Check All"));
    this->checkAll->setChecked(true);
    connect(this->checkAll, SIGNAL(clicked()), this, SLOT(slot_checkAll()));

    this->checkVideo = new DCheckBox(this);
    this->checkVideo->setGeometry(105, 401, 95, 29);
    this->checkVideo->setText(tr("Video"));
    this->checkVideo->setChecked(true);
    connect(this->checkVideo, SIGNAL(clicked()), this, SLOT(slot_checkVideo()));

    this->checkAudio = new DCheckBox(this);
    this->checkAudio->setGeometry(195, 401, 95, 29);
    this->checkAudio->setText(tr("Audio"));
    this->checkAudio->setChecked(true);
    connect(this->checkAudio, SIGNAL(clicked()), this, SLOT(slot_checkAudio()));

    this->checkPicture = new DCheckBox(this);
    this->checkPicture->setGeometry(285, 401, 95, 29);
    this->checkPicture->setText(tr("Picture"));
    this->checkPicture->setChecked(true);
    connect(this->checkPicture, SIGNAL(clicked()), this, SLOT(slot_checkPicture()));

    this->checkOther = new DCheckBox(this);
    this->checkOther->setGeometry(375, 401, 95, 29);
    this->checkOther->setText(tr("Other"));
    this->checkOther->setChecked(true);
    connect(this->checkOther, SIGNAL(clicked()), this, SLOT(slot_checkOther()));

    //下载路径所在分区剩余磁盘容量
    this->labelCapacityFree = new DLabel();
    //this->labelCapacityFree->setGeometry(350, 363, 86, 23);
    this->labelCapacityFree->setText(tr("Free:") + Aria2cInterface::getCapacityFree(this->defaultDownloadDir));
    this->labelCapacityFree->setPalette(pal);
    this->labelCapacityFree->setFont(font2);

    //
    this->editDir = new DFileChooserEdit(this);
    this->editDir->setGeometry(15, 435, 471, 36);
    this->editDir->setText(this->defaultDownloadDir);
    this->editDir->setClearButtonEnabled(false);
    this->editDir->setFileMode(QFileDialog::DirectoryOnly);
    this->editDir->lineEdit()->setEnabled(false);
    connect(this->editDir, &DFileChooserEdit::fileChoosed, this, &BtInfoDialog::slot_filechoosed);

    //确定按钮
    this->btnOK = new DPushButton(this);
    //this->btnOK->setFixedWidth(190);
    this->btnOK->setGeometry(160, 480, 191, 35);
    this->btnOK->setText(tr("Download"));
    connect(this->btnOK, SIGNAL(clicked()), this, SLOT(slot_btnOK()));

    //文件列表配置
    this->tableView->setShowGrid(false);
    this->tableView->setSelectionMode(QAbstractItemView::NoSelection);
    this->tableView->setSelectionBehavior(QAbstractItemView::SelectRows);
    this->tableView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    this->tableView->setAlternatingRowColors(true);
    this->tableView->setFrameShape(QAbstractItemView::NoFrame);

    QFont font;
    font.setPixelSize(13);
    this->tableView->setFont(font);

    this->tableView->horizontalHeader()->setDefaultAlignment(Qt::AlignLeft);
    this->tableView->horizontalHeader()->setHighlightSections(false);

    this->tableView->verticalHeader()->hide();
    this->tableView->verticalHeader()->setDefaultSectionSize(46);

    this->delegate = new BtInfoDelegate(this);
    this->tableView->setItemDelegate(delegate);

    this->model = new QStandardItemModel();
    this->tableView->setModel(this->model);

    model->setColumnCount(5);
    model->setHeaderData(0, Qt::Horizontal, tr("File Name"));
    model->setHeaderData(1, Qt::Horizontal, "");
    model->setHeaderData(2, Qt::Horizontal, tr("Type"));
    model->setHeaderData(3, Qt::Horizontal, tr("Size"));
    model->setHeaderData(4, Qt::Horizontal, "index");

    for(int i = 0; i < info.files.length();i++) {
        Aria2cBtFile file = info.files.at(i);
        QList<QStandardItem*> list;
        list << new QStandardItem("1");
        list << new QStandardItem(file.path.mid(file.path.lastIndexOf("/") + 1));
        list << new QStandardItem(file.path.mid(file.path.lastIndexOf(".") + 1));
        list << new QStandardItem(file.length);
        list << new QStandardItem(QString::number(file.index));
        list << new QStandardItem(QString::number(file.lengthBytes));
        this->model->appendRow(list);
    }

    //this->tableView->setColumnHidden(0, true);
    this->tableView->setColumnHidden(1, true);
    this->tableView->setColumnHidden(4, true);
    this->tableView->setColumnHidden(5, true);

    this->tableView->setColumnWidth(0, 290);
    //this->tableView->setColumnWidth(1, 260);
    this->tableView->setColumnWidth(2, 60);
    //this->tableView->setColumnWidth(3, 60);
    this->tableView->horizontalHeader()->setStretchLastSection(true);

    connect(this->tableView, &BtInfoTableView::signal_hoverChanged, this->delegate, &BtInfoDelegate::slot_hoverChanged);

    slot_paletteTypeChanged(DGuiApplicationHelper::ColorType::LightType);
}

int BtInfoDialog::exec()
{
    QHBoxLayout layout(editDir->lineEdit());
    layout.addWidget(labelCapacityFree, 0, Qt::AlignRight | Qt::AlignCenter);
    this->editDir->setFixedHeight(36);

    return DDialog::exec();
}

void BtInfoDialog::slot_btnSelectDir()
{
    QString dir = DFileDialog::getExistingDirectory(nullptr, tr("Select Downlod to Dir"), this->defaultDownloadDir);
    if(dir != "") {
        this->editDir->setText(dir);
        this->labelCapacityFree->setText(tr("Free:") + Aria2cInterface::getCapacityFree(dir));
    }
}

void BtInfoDialog::slot_btnOK()
{
    //qDebug()<<Aria2cInterface::getCapacityFree(editDir->text());
    long free = Aria2cInterface::getCapacityFreeByte(editDir->text());//KB
    long total = 0;//选中文件总大小（字节）
    for(int i = 0;i < model->rowCount();i++) {
        if(model->data(model->index(i, 0)).toString() == "1") {
            total += model->data(model->index(i, 5)).toString().toLong();
        }
    }
    //qDebug()<<free<<total/1024;
    if(free < (total / 1024)) {//剩余空间比较 KB
        MessageBox *msg = new MessageBox(Warnings);
        msg->set_warning_MsgBox(tr("Disk capacity is not enough!"), tr("sure"));//磁盘容量不足！
        msg->exec();
        return;
    }
    if(this->getSelected() != "") {
        QString save_path=editDir->text();
        QString config_path=QString("%1/%2/%3/last_save_path")
                .arg(QStandardPaths::writableLocation(QStandardPaths::ConfigLocation))
                .arg(qApp->organizationName())
                .arg(qApp->applicationName());
        QFile file;
        file.setFileName(config_path);
        bool isOK = file.open(QIODevice::WriteOnly);
        if (isOK == true)
        {
            file.write(save_path.toStdString().data());
        }
        file.close();
        this->close();
        this->accept();
    }
    else {
        MessageBox *msg = new MessageBox(Warnings);
        msg->set_warning_MsgBox(tr("Please Select Download Files!"), tr("sure"));
        msg->exec();
    }
}

void BtInfoDialog::slot_checkAll()
{
    int state = this->checkAll->checkState();
    if(state == Qt::Checked) {
        for(int i = 0;i < model->rowCount();i++) {
            model->setData(model->index(i, 0), "1");
        }
        this->labelSelectedFileNum->setText(tr("Selected Files:") + QString::number(model->rowCount()) + tr(",Total ") + Aria2cInterface::bytesFormat(this->info.totalLengthByets));
        this->checkVideo->setCheckState(Qt::Checked);
        this->checkAudio->setCheckState(Qt::Checked);
        this->checkPicture->setCheckState(Qt::Checked);
        this->checkOther->setCheckState(Qt::Checked);
    }
    else if(state == Qt::Unchecked) {
        for(int i = 0;i < model->rowCount();i++) {
            model->setData(model->index(i, 0), "0");
            this->labelSelectedFileNum->setText(tr("Selected Files:") + "0" + tr(",Total ") + "0B");
        }
        this->checkVideo->setCheckState(Qt::Unchecked);
        this->checkAudio->setCheckState(Qt::Unchecked);
        this->checkPicture->setCheckState(Qt::Unchecked);
        this->checkOther->setCheckState(Qt::Unchecked);
    }
}

bool BtInfoDialog::isVideo(QString ext) {
    QString types = "avi,mp4,mkv,flv,f4v,wmv,rmvb,rm,mpeg,mpg,mov,ts,m4v,vob";
    return types.indexOf(ext) != -1;
}

bool BtInfoDialog::isAudio(QString ext) {
    QString types = "mp3,ogg,wav,ape,flac,wma,midi,aac,cda";
    return types.indexOf(ext) != -1;
}

bool BtInfoDialog::isPicture(QString ext) {
    QString types = "jpg,jpeg,gif,png,bmp,svg,psd,tif,ico";
    return types.indexOf(ext) != -1;
}

void BtInfoDialog::slot_checkVideo()
{
    int state = this->checkVideo->checkState();
    if(this->checkVideo->checkState() == Qt::Checked
            && this->checkAudio->checkState() == Qt::Checked
            && this->checkPicture->checkState() == Qt::Checked
            && this->checkOther->checkState() == Qt::Checked) {
        this->checkAll->setCheckState(Qt::Checked);
    }
    else {
        this->checkAll->setCheckState(Qt::Unchecked);
    }

    long total = 0;
    int cnt = 0;
    for(int i = 0;i < model->rowCount();i++) {
        QString ext = model->data(model->index(i, 2)).toString();
        if(isVideo(ext)) {
            model->setData(model->index(i, 0), state == Qt::Checked ? "1" : "0");
        }
        if(model->data(model->index(i, 0)).toString() == "1") {
            total += model->data(model->index(i, 5)).toString().toLong();
            cnt++;
        }
    }
    this->labelSelectedFileNum->setText(tr("Selected Files:") + QString::number(cnt) + tr(",Total ") + Aria2cInterface::bytesFormat(total));
}

void BtInfoDialog::slot_checkAudio()
{
    int state = this->checkAudio->checkState();
    if(this->checkVideo->checkState() == Qt::Checked
            && this->checkAudio->checkState() == Qt::Checked
            && this->checkPicture->checkState() == Qt::Checked
            && this->checkOther->checkState() == Qt::Checked) {
        this->checkAll->setCheckState(Qt::Checked);
    }
    else {
        this->checkAll->setCheckState(Qt::Unchecked);
    }

    long total = 0;
    int cnt = 0;
    for(int i = 0;i < model->rowCount();i++) {
        QString ext = model->data(model->index(i, 2)).toString();
        if(isAudio(ext)) {
            model->setData(model->index(i, 0), state == Qt::Checked ? "1" : "0");
        }
        if(model->data(model->index(i, 0)).toString() == "1") {
            total += model->data(model->index(i, 5)).toString().toLong();
            cnt++;
        }
    }
    this->labelSelectedFileNum->setText(tr("Selected Files:") + QString::number(cnt) + tr(",Total ") + Aria2cInterface::bytesFormat(total));
}

void BtInfoDialog::slot_checkPicture()
{
    int state = this->checkPicture->checkState();
    if(this->checkVideo->checkState() == Qt::Checked
            && this->checkAudio->checkState() == Qt::Checked
            && this->checkPicture->checkState() == Qt::Checked
            && this->checkOther->checkState() == Qt::Checked) {
        this->checkAll->setCheckState(Qt::Checked);
    }
    else {
        this->checkAll->setCheckState(Qt::Unchecked);
    }

    long total = 0;
    int cnt = 0;
    for(int i = 0;i < model->rowCount();i++) {
        QString ext = model->data(model->index(i, 2)).toString();
        if(isPicture(ext)) {
            model->setData(model->index(i, 0), state == Qt::Checked ? "1" : "0");
        }
        if(model->data(model->index(i, 0)).toString() == "1") {
            total += model->data(model->index(i, 5)).toString().toLong();
            cnt++;
        }
    }
    this->labelSelectedFileNum->setText(tr("Selected Files:") + QString::number(cnt) + tr(",Total ") + Aria2cInterface::bytesFormat(total));
}

void BtInfoDialog::slot_checkOther()
{
    int state = this->checkOther->checkState();
    if(this->checkVideo->checkState() == Qt::Checked
            && this->checkAudio->checkState() == Qt::Checked
            && this->checkPicture->checkState() == Qt::Checked
            && this->checkOther->checkState() == Qt::Checked) {
        this->checkAll->setCheckState(Qt::Checked);
    }
    else {
        this->checkAll->setCheckState(Qt::Unchecked);
    }
    long total = 0;
    int cnt = 0;
    for(int i = 0;i < model->rowCount();i++) {
        QString ext = model->data(model->index(i, 2)).toString();
        if(!isVideo(ext) && !isAudio(ext) && !isPicture(ext)) {
            model->setData(model->index(i, 0), state == Qt::Checked ? "1" : "0");
        }
        if(model->data(model->index(i, 0)).toString() == "1") {
            total += model->data(model->index(i, 5)).toString().toLong();
            cnt++;
        }
    }
    this->labelSelectedFileNum->setText(tr("Selected Files:") + QString::number(cnt) + tr(",Total ") + Aria2cInterface::bytesFormat(total));
}

void BtInfoDialog::updateSelectedInfo()
{
    int cnt = 0;
    long total = 0;
    for(int i = 0;i < model->rowCount();i++) {
        QString v = model->data(model->index(i, 0)).toString();
        if(v == "1") {
            total += model->data(model->index(i, 5)).toString().toLong();
            cnt++;
        }
    }
    this->labelSelectedFileNum->setText(tr("Selected Files:") + QString::number(cnt) + tr(",Total ") + Aria2cInterface::bytesFormat(total));
}

void BtInfoDialog::slot_filechoosed(const QString &filename)
{
    QFileInfo fileinfo;
    fileinfo.setFile(filename);
    if(!fileinfo.isWritable())
    {
        MessageBox *msg = new MessageBox(Warnings);
        msg->set_warning_MsgBox(tr("select directory not writeable"), tr("sure"));
        msg->exec();
        this->editDir->lineEdit()->setText(this->defaultDownloadDir);
    }
    this->labelCapacityFree->setText(tr("Free:") + Aria2cInterface::getCapacityFree(this->editDir->text()));
}

void BtInfoDialog::slot_paletteTypeChanged(DGuiApplicationHelper::ColorType type)
{
    int themeType = DGuiApplicationHelper::instance()->themeType();
    QPalette p;
    this->delegate->setHoverColor(DGuiApplicationHelper::instance()->applicationPalette().frameBorder());

    if(themeType == 1) {
        p.setColor(QPalette::Background, Qt::white);
        //this->delegate->setHoverColor(QColor(0,0,0,13));

        QPalette pal;
        pal.setColor(QPalette::WindowText, QColor("#8AA1B4"));
        this->labelFileSize->setPalette(pal);
        this->labelSelectedFileNum->setPalette(pal);
    }
    else {
        p = DGuiApplicationHelper::instance()->applicationPalette();
       // this->delegate->setHoverColor(QColor(255,255,255,26));

        this->labelFileSize->setPalette(DGuiApplicationHelper::instance()->applicationPalette());
        this->labelSelectedFileNum->setPalette(DGuiApplicationHelper::instance()->applicationPalette());
    }
    this->widget->setPalette(p);

}
