#include "../common/tdb_private.h"
#include "../common/io.c"
#include "../common/tdb.c"
#include "../common/lock.c"
#include "../common/freelist.c"
#include "../common/traverse.c"
#include "../common/transaction.c"
#include "../common/error.c"
#include "../common/open.c"
#include "../common/check.c"
#include "../common/hash.c"
#include "../common/mutex.c"
#include "tap-interface.h"
#include <stdlib.h>
#include <stdbool.h>
#include "logging.h"

int main(int argc, char *argv[])
{
	struct tdb_context *tdb;
	TDB_DATA key, data;

	plan_tests(27);
	key.dsize = strlen("hi");
	key.dptr = discard_const_p(uint8_t, "hi");

	tdb = tdb_open_ex("run-nested-transactions.tdb",
			  1024, TDB_CLEAR_IF_FIRST|TDB_DISALLOW_NESTING,
			  O_CREAT|O_TRUNC|O_RDWR, 0600, &taplogctx, NULL);
	ok1(tdb);

	/* Nesting disallowed. */
	ok1(tdb_transaction_start(tdb) == 0);
	data.dptr = discard_const_p(uint8_t, "world");
	data.dsize = strlen("world");
	ok1(tdb_store(tdb, key, data, TDB_INSERT) == 0);
	data = tdb_fetch(tdb, key);
	ok1(data.dsize == strlen("world"));
	ok1(memcmp(data.dptr, "world", strlen("world")) == 0);
	free(data.dptr);
	ok1(tdb_transaction_start(tdb) != 0);
	ok1(tdb_error(tdb) == TDB_ERR_NESTING);

	data = tdb_fetch(tdb, key);
	ok1(data.dsize == strlen("world"));
	ok1(memcmp(data.dptr, "world", strlen("world")) == 0);
	free(data.dptr);
	ok1(tdb_transaction_commit(tdb) == 0);
	data = tdb_fetch(tdb, key);
	ok1(data.dsize == strlen("world"));
	ok1(memcmp(data.dptr, "world", strlen("world")) == 0);
	free(data.dptr);
	tdb_close(tdb);

	/* Nesting allowed by default */
	tdb = tdb_open_ex("run-nested-transactions.tdb",
			  1024, TDB_DEFAULT, O_RDWR, 0, &taplogctx, NULL);
	ok1(tdb);

	ok1(tdb_transaction_start(tdb) == 0);
	ok1(tdb_transaction_start(tdb) == 0);
	ok1(tdb_delete(tdb, key) == 0);
	ok1(tdb_transaction_commit(tdb) == 0);
	ok1(!tdb_exists(tdb, key));
	ok1(tdb_transaction_cancel(tdb) == 0);
	/* Surprise! Kills inner "committed" transaction. */
	ok1(tdb_exists(tdb, key));

	ok1(tdb_transaction_start(tdb) == 0);
	ok1(tdb_transaction_start(tdb) == 0);
	ok1(tdb_delete(tdb, key) == 0);
	ok1(tdb_transaction_commit(tdb) == 0);
	ok1(!tdb_exists(tdb, key));
	ok1(tdb_transaction_commit(tdb) == 0);
	ok1(!tdb_exists(tdb, key));
	tdb_close(tdb);

	return exit_status();
}
