% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2.R
\name{image_ggplot}
\alias{image_ggplot}
\title{Image to ggplot}
\usage{
image_ggplot(image)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}
}
\description{
Converts image to raster using \code{\link[=image_raster]{image_raster()}} and then plots it with ggplot2
\link[ggplot2:geom_raster]{geom_raster}. See examples for other ways to use magick
images in ggplot2.
}
\examples{
# Plot with base R
plot(logo)

# Plot image with ggplot2
library(ggplot2)
myplot <- image_ggplot(logo)
myplot + ggtitle("Test plot")

# Or add to plot as annotation
image <- image_fill(logo, 'none')
raster <- as.raster(image)
myplot <- qplot(mpg, wt, data = mtcars)
myplot + annotation_raster(raster, 25, 35, 3, 5)

# Or overplot image using grid
library(grid)
qplot(speed, dist, data = cars, geom = c("point", "smooth"))
grid.raster(image)
}
