# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RemoteReplicatorStatus(Model):
    """Represents the state of the secondary replicator from the primary
    replicator’s point of view.

    :param replica_id: Represents the replica ID of the remote secondary
     replicator.
    :type replica_id: str
    :param last_acknowledgement_processed_time_utc: The last timestamp (in
     UTC) when an acknowledgement from the secondary replicator was processed
     on the primary.
     UTC 0 represents an invalid value, indicating that no acknowledgement
     messages were ever processed.
    :type last_acknowledgement_processed_time_utc: datetime
    :param last_received_replication_sequence_number: The highest replication
     operation sequence number that the secondary has received from the
     primary.
    :type last_received_replication_sequence_number: str
    :param last_applied_replication_sequence_number: The highest replication
     operation sequence number that the secondary has applied to its state.
    :type last_applied_replication_sequence_number: str
    :param is_in_build: A value that indicates whether the secondary replica
     is in the process of being built.
    :type is_in_build: bool
    :param last_received_copy_sequence_number: The highest copy operation
     sequence number that the secondary has received from the primary.
     A value of -1 implies that the secondary has received all copy operations.
    :type last_received_copy_sequence_number: str
    :param last_applied_copy_sequence_number: The highest copy operation
     sequence number that the secondary has applied to its state.
     A value of -1 implies that the secondary has applied all copy operations
     and the copy process is complete.
    :type last_applied_copy_sequence_number: str
    :param remote_replicator_acknowledgement_status: Represents the
     acknowledgment status for the remote secondary replicator.
    :type remote_replicator_acknowledgement_status:
     ~azure.servicefabric.models.RemoteReplicatorAcknowledgementStatus
    """

    _attribute_map = {
        'replica_id': {'key': 'ReplicaId', 'type': 'str'},
        'last_acknowledgement_processed_time_utc': {'key': 'LastAcknowledgementProcessedTimeUtc', 'type': 'iso-8601'},
        'last_received_replication_sequence_number': {'key': 'LastReceivedReplicationSequenceNumber', 'type': 'str'},
        'last_applied_replication_sequence_number': {'key': 'LastAppliedReplicationSequenceNumber', 'type': 'str'},
        'is_in_build': {'key': 'IsInBuild', 'type': 'bool'},
        'last_received_copy_sequence_number': {'key': 'LastReceivedCopySequenceNumber', 'type': 'str'},
        'last_applied_copy_sequence_number': {'key': 'LastAppliedCopySequenceNumber', 'type': 'str'},
        'remote_replicator_acknowledgement_status': {'key': 'RemoteReplicatorAcknowledgementStatus', 'type': 'RemoteReplicatorAcknowledgementStatus'},
    }

    def __init__(self, **kwargs):
        super(RemoteReplicatorStatus, self).__init__(**kwargs)
        self.replica_id = kwargs.get('replica_id', None)
        self.last_acknowledgement_processed_time_utc = kwargs.get('last_acknowledgement_processed_time_utc', None)
        self.last_received_replication_sequence_number = kwargs.get('last_received_replication_sequence_number', None)
        self.last_applied_replication_sequence_number = kwargs.get('last_applied_replication_sequence_number', None)
        self.is_in_build = kwargs.get('is_in_build', None)
        self.last_received_copy_sequence_number = kwargs.get('last_received_copy_sequence_number', None)
        self.last_applied_copy_sequence_number = kwargs.get('last_applied_copy_sequence_number', None)
        self.remote_replicator_acknowledgement_status = kwargs.get('remote_replicator_acknowledgement_status', None)
