# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ManagedClusterAADProfile(Model):
    """AADProfile specifies attributes for Azure Active Directory integration.

    All required parameters must be populated in order to send to Azure.

    :param client_app_id: Required. The client AAD application ID.
    :type client_app_id: str
    :param server_app_id: Required. The server AAD application ID.
    :type server_app_id: str
    :param server_app_secret: Required. The server AAD application secret.
    :type server_app_secret: str
    :param tenant_id: The AAD tenant ID to use for authentication. If not
     specified, will use the tenant of the deployment subscription.
    :type tenant_id: str
    """

    _validation = {
        'client_app_id': {'required': True},
        'server_app_id': {'required': True},
        'server_app_secret': {'required': True},
    }

    _attribute_map = {
        'client_app_id': {'key': 'clientAppID', 'type': 'str'},
        'server_app_id': {'key': 'serverAppID', 'type': 'str'},
        'server_app_secret': {'key': 'serverAppSecret', 'type': 'str'},
        'tenant_id': {'key': 'tenantID', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterAADProfile, self).__init__(**kwargs)
        self.client_app_id = kwargs.get('client_app_id', None)
        self.server_app_id = kwargs.get('server_app_id', None)
        self.server_app_secret = kwargs.get('server_app_secret', None)
        self.tenant_id = kwargs.get('tenant_id', None)
