# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RankingRankingItem(Model):
    """Defines a search result item to display.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param answer_type: Required. The answer that contains the item to
     display. Use the type to find the answer in the SearchResponse object. The
     type is the name of a SearchResponse field. Possible values include:
     'WebPages', 'Images', 'SpellSuggestions', 'News', 'RelatedSearches',
     'Videos', 'Computation', 'TimeZone'. Default value: "WebPages" .
    :type answer_type: str or
     ~azure.cognitiveservices.search.websearch.models.AnswerType
    :ivar result_index: A zero-based index of the item in the answer.If the
     item does not include this field, display all items in the answer. For
     example, display all news articles in the News answer.
    :vartype result_index: int
    :ivar value: The ID that identifies either an answer to display or an item
     of an answer to display. If the ID identifies an answer, display all items
     of the answer.
    :vartype value:
     ~azure.cognitiveservices.search.websearch.models.Identifiable
    :ivar html_index:
    :vartype html_index: int
    :ivar textual_index:
    :vartype textual_index: int
    :ivar screenshot_index:
    :vartype screenshot_index: int
    """

    _validation = {
        'answer_type': {'required': True},
        'result_index': {'readonly': True},
        'value': {'readonly': True},
        'html_index': {'readonly': True},
        'textual_index': {'readonly': True},
        'screenshot_index': {'readonly': True},
    }

    _attribute_map = {
        'answer_type': {'key': 'answerType', 'type': 'str'},
        'result_index': {'key': 'resultIndex', 'type': 'int'},
        'value': {'key': 'value', 'type': 'Identifiable'},
        'html_index': {'key': 'htmlIndex', 'type': 'int'},
        'textual_index': {'key': 'textualIndex', 'type': 'int'},
        'screenshot_index': {'key': 'screenshotIndex', 'type': 'int'},
    }

    def __init__(self, *, answer_type="WebPages", **kwargs) -> None:
        super(RankingRankingItem, self).__init__(**kwargs)
        self.answer_type = answer_type
        self.result_index = None
        self.value = None
        self.html_index = None
        self.textual_index = None
        self.screenshot_index = None
