# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SpellingFlaggedToken(Model):
    """SpellingFlaggedToken.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param offset: Required.
    :type offset: int
    :param token: Required.
    :type token: str
    :param type: Required. Possible values include: 'UnknownToken',
     'RepeatedToken'. Default value: "UnknownToken" .
    :type type: str or
     ~azure.cognitiveservices.language.spellcheck.models.ErrorType
    :ivar suggestions:
    :vartype suggestions:
     list[~azure.cognitiveservices.language.spellcheck.models.SpellingTokenSuggestion]
    :ivar ping_url_suffix:
    :vartype ping_url_suffix: str
    """

    _validation = {
        'offset': {'required': True},
        'token': {'required': True},
        'type': {'required': True},
        'suggestions': {'readonly': True},
        'ping_url_suffix': {'readonly': True},
    }

    _attribute_map = {
        'offset': {'key': 'offset', 'type': 'int'},
        'token': {'key': 'token', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'suggestions': {'key': 'suggestions', 'type': '[SpellingTokenSuggestion]'},
        'ping_url_suffix': {'key': 'pingUrlSuffix', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SpellingFlaggedToken, self).__init__(**kwargs)
        self.offset = kwargs.get('offset', None)
        self.token = kwargs.get('token', None)
        self.type = kwargs.get('type', "UnknownToken")
        self.suggestions = None
        self.ping_url_suffix = None
