# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceFile(Model):
    """A file to be downloaded from Azure blob storage to a compute node.

    All required parameters must be populated in order to send to Azure.

    :param blob_source: Required. The URL of the file within Azure Blob
     Storage. This URL must be readable using anonymous access; that is, the
     Batch service does not present any credentials when downloading the blob.
     There are two ways to get such a URL for a blob in Azure storage: include
     a Shared Access Signature (SAS) granting read permissions on the blob, or
     set the ACL for the blob or its container to allow public access.
    :type blob_source: str
    :param file_path: Required. The location on the compute node to which to
     download the file, relative to the task's working directory.
    :type file_path: str
    :param file_mode: The file permission mode attribute in octal format. This
     property applies only to files being downloaded to Linux compute nodes. It
     will be ignored if it is specified for a resourceFile which will be
     downloaded to a Windows node. If this property is not specified for a
     Linux node, then a default value of 0770 is applied to the file.
    :type file_mode: str
    """

    _validation = {
        'blob_source': {'required': True},
        'file_path': {'required': True},
    }

    _attribute_map = {
        'blob_source': {'key': 'blobSource', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
        'file_mode': {'key': 'fileMode', 'type': 'str'},
    }

    def __init__(self, *, blob_source: str, file_path: str, file_mode: str=None, **kwargs) -> None:
        super(ResourceFile, self).__init__(**kwargs)
        self.blob_source = blob_source
        self.file_path = file_path
        self.file_mode = file_mode
